"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDocument = exports.fromEs = exports.createAttributes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fromEs = document => {
  if (!document._source) {
    throw new Error('No source found on get conversation response');
  }
  return {
    id: document._source.id,
    type: document._source.type,
    description: document._source.description,
    tags: document._source.tags,
    configuration: document._source.configuration,
    updated_at: document._source.updated_at,
    created_at: document._source.created_at
  };
};
exports.fromEs = fromEs;
const createAttributes = ({
  createRequest,
  space,
  creationDate = new Date()
}) => {
  var _createRequest$descri, _createRequest$tags;
  return {
    id: createRequest.id,
    type: createRequest.type,
    space,
    description: (_createRequest$descri = createRequest.description) !== null && _createRequest$descri !== void 0 ? _createRequest$descri : '',
    tags: (_createRequest$tags = createRequest.tags) !== null && _createRequest$tags !== void 0 ? _createRequest$tags : [],
    configuration: createRequest.configuration,
    created_at: creationDate.toISOString(),
    updated_at: creationDate.toISOString()
  };
};
exports.createAttributes = createAttributes;
const updateDocument = ({
  current,
  update,
  updateDate = new Date()
}) => {
  return {
    ...current,
    ...update,
    configuration: {
      ...current.configuration,
      ...update.configuration
    },
    updated_at: updateDate.toISOString()
  };
};
exports.updateDocument = updateDocument;