"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPolicies = void 0;
var _lodash = require("lodash");
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentPolicies = () => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['agentPolicies'], () => http.get('/internal/osquery/fleet_wrapper/agent_policies', {
    version: _constants.API_VERSIONS.internal.v1
  }), {
    initialData: [],
    keepPreviousData: true,
    select: response => ({
      agentPoliciesById: (0, _lodash.mapKeys)(response, 'id'),
      agentPolicies: response
    }),
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.agent_policies.fetchError', {
        defaultMessage: 'Error while fetching agent policies'
      })
    })
  });
};
exports.useAgentPolicies = useAgentPolicies;