"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentPolicy = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentPolicy = ({
  policyId,
  skip,
  silent
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['agentPolicy', {
    policyId
  }], () => http.get(`/internal/osquery/fleet_wrapper/agent_policies/${policyId}`, {
    version: _constants.API_VERSIONS.internal.v1
  }), {
    enabled: !!(policyId && !skip),
    keepPreviousData: true,
    select: response => response.item,
    onSuccess: () => setErrorToast(),
    onError: error => !silent && setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.agent_policy_details.fetchError', {
        defaultMessage: 'Error while fetching agent policy details'
      })
    })
  });
};
exports.useAgentPolicy = useAgentPolicy;