"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatformCheckBoxGroupField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _i18n = require("@kbn/i18n");
var _platform_icon = require("./platforms/platform_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/osquery/public/packs/queries/platform_checkbox_group_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PlatformCheckBoxGroupField = props => {
  const {
    euiFieldProps = {},
    idAria,
    helpText,
    ...rest
  } = props;
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'platform',
    defaultValue: []
  });
  const options = (0, _react.useMemo)(() => [{
    id: 'linux',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_platform_icon.PlatformIcon, {
      platform: "linux",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.pack.queryFlyoutForm.platformMacOSLabel",
      defaultMessage: "Linux",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 15
      }
    })))
  }, {
    id: 'darwin',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_platform_icon.PlatformIcon, {
      platform: "darwin",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.pack.queryFlyoutForm.platformLinusLabel",
      defaultMessage: "macOS",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 15
      }
    })))
  }, {
    id: 'windows',
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_platform_icon.PlatformIcon, {
      platform: "windows",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.pack.queryFlyoutForm.platformWindowsLabel",
      defaultMessage: "Windows",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    })))
  }], []);
  const [checkboxIdToSelectedMap, setCheckboxIdToSelectedMap] = (0, _react.useState)(() => options.reduce((acc, option) => {
    var _value$includes;
    acc[option.id] = (0, _lodash.isEmpty)(value) ? true : (_value$includes = value === null || value === void 0 ? void 0 : value.includes(option.id)) !== null && _value$includes !== void 0 ? _value$includes : false;
    return acc;
  }, {}));
  const handleChange = (0, _react.useCallback)(optionId => {
    const newCheckboxIdToSelectedMap = {
      ...checkboxIdToSelectedMap,
      [optionId]: !checkboxIdToSelectedMap[optionId]
    };
    setCheckboxIdToSelectedMap(newCheckboxIdToSelectedMap);
    onChange(Object.keys((0, _lodash.pickBy)(newCheckboxIdToSelectedMap, checkboxValue => checkboxValue === true)).join(','));
  }, [checkboxIdToSelectedMap, onChange]);
  const describedByIds = (0, _react.useMemo)(() => idAria ? [idAria] : [], [idAria]);
  (0, _react.useEffect)(() => {
    setCheckboxIdToSelectedMap(() => options.reduce((acc, option) => {
      var _value$includes2;
      acc[option.id] = (0, _lodash.isEmpty)(value) ? true : (_value$includes2 = value === null || value === void 0 ? void 0 : value.includes(option.id)) !== null && _value$includes2 !== void 0 ? _value$includes2 : false;
      return acc;
    }, {}));
  }, [value, options]);
  const hasError = (0, _react.useMemo)(() => !!(error !== null && error !== void 0 && error.message), [error === null || error === void 0 ? void 0 : error.message]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.platformFieldLabel', {
      defaultMessage: 'Platform'
    }),
    helpText: typeof helpText === 'function' ? helpText() : helpText,
    error: error === null || error === void 0 ? void 0 : error.message,
    isInvalid: hasError,
    fullWidth: true,
    describedByIds: describedByIds
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, (0, _extends2.default)({
    idToSelectedMap: checkboxIdToSelectedMap,
    options: options,
    onChange: handleChange,
    "data-test-subj": "osquery-platform-checkbox-group"
  }, euiFieldProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  })));
};
exports.PlatformCheckBoxGroupField = PlatformCheckBoxGroupField;