"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibana7Palette = void 0;
var _i18n = require("@kbn/i18n");
var _categorical_palette = require("../../../classes/categorical_palette");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const kibana7Palette = exports.kibana7Palette = new _categorical_palette.KbnCategoricalPalette({
  id: _constants.KbnPalette.Kibana7,
  aliases: [_constants.KbnPalette.Default,
  // needed when switching between new and old themes
  _constants.KbnPalette.Amsterdam // to assign to existing default palettes
  ],
  name: _i18n.i18n.translate('palettes.kibana7.name', {
    defaultMessage: 'Kibana 7.0'
  }),
  colorCount: 10,
  colors: ['#54b399', '#6092c0', '#d36086', '#9170b8', '#ca8eae', '#d6bf57', '#b9a888', '#da8b45', '#aa6556', '#e7664c', '#7fc6b3', '#88aed0', '#de88a5', '#ad94ca', '#d8abc3', '#e1cf81', '#cbbea6', '#e4a874', '#c08c81', '#ed8d79', '#aad9cc', '#b0c9e0', '#e9b0c3', '#c8b8dc', '#e5c7d7', '#ebdfab', '#dcd4c4', '#edc5a2', '#d5b2ab', '#f3b3a6']
});