"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProfilingHostsDetailsById = getProfilingHostsDetailsById;
var _server = require("@kbn/observability-plugin/server");
var _lodash = require("lodash");
var _profilingUtils = require("@kbn/profiling-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getProfilingHostsDetailsById({
  client,
  timeFrom,
  timeTo,
  kuery,
  hostIds
}) {
  var _resp$aggregations;
  const resp = await client.search('get_host_ids_names', {
    index: 'profiling-hosts',
    size: 0,
    query: {
      bool: {
        filter: [{
          terms: {
            [_profilingUtils.ProfilingESField.HostID]: hostIds
          }
        }, {
          range: {
            [_profilingUtils.ProfilingESField.Timestamp]: {
              gte: String(timeFrom),
              lt: String(timeTo),
              format: 'epoch_second'
            }
          }
        }, ...(0, _server.kqlQuery)(kuery)]
      }
    },
    aggs: {
      hostIds: {
        terms: {
          field: _profilingUtils.ProfilingESField.HostID
        },
        aggs: {
          hostNames: {
            top_metrics: {
              metrics: {
                field: 'profiling.host.name'
              },
              sort: '_score'
            }
          },
          projectIds: {
            terms: {
              field: 'profiling.project.id'
            },
            aggs: {
              probabilisticValues: {
                terms: {
                  field: 'profiling.agent.config.probabilistic_threshold',
                  size: 5,
                  order: {
                    agentFirstStartDate: 'desc'
                  }
                },
                aggs: {
                  agentFirstStartDate: {
                    min: {
                      field: 'profiling.agent.start_time'
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  });
  const hostsDetails = ((_resp$aggregations = resp.aggregations) === null || _resp$aggregations === void 0 ? void 0 : _resp$aggregations.hostIds.buckets.map(bucket => {
    const hostId = bucket.key;
    const hostName = bucket.hostNames.top[0].metrics['profiling.host.name'];
    const probabilisticValuesPerProject = bucket.projectIds.buckets.map(projectIdBucket => {
      const projectId = projectIdBucket.key;
      const probabilisticValues = projectIdBucket.probabilisticValues.buckets.map(probValuesBucket => {
        return {
          value: probValuesBucket.key,
          date: probValuesBucket.agentFirstStartDate.value
        };
      });
      return {
        projectId,
        probabilisticValues
      };
    });
    return {
      hostId,
      hostName,
      probabilisticValuesPerProject: (0, _lodash.keyBy)(probabilisticValuesPerProject, 'projectId')
    };
  })) || [];
  return (0, _lodash.keyBy)(hostsDetails, 'hostId');
}