"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decryptJobHeaders = void 0;
var _i18n = require("@kbn/i18n");
var _crypto = require("./crypto");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const decryptJobHeaders = async (encryptionKey, headers, logger) => {
  try {
    if (typeof headers !== 'string') {
      throw new Error(_i18n.i18n.translate('reporting.commonExportTypesHelpers.missingJobHeadersErrorMessage', {
        defaultMessage: 'Job headers are missing'
      }));
    }
    const crypto = (0, _crypto.cryptoFactory)(encryptionKey);
    const decryptedHeaders = await crypto.decrypt(headers);
    return decryptedHeaders;
  } catch (err) {
    logger.error(err);
    throw new Error(_i18n.i18n.translate('reporting.commonExportTypesHelpers.failedToDecryptReportJobDataErrorMessage', {
      defaultMessage: 'Failed to decrypt report job data. Please ensure that {encryptionKey} is set and re-generate this report. {err}',
      values: {
        encryptionKey: 'xpack.reporting.encryptionKey',
        err: err.toString()
      }
    }));
  }
};
exports.decryptJobHeaders = decryptJobHeaders;