"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RUNTIME_FIELD_TYPES2 = exports.RUNTIME_FIELD_TYPES = exports.MAX_SELECTABLE_SOURCE_FIELDS = exports.MAX_SELECTABLE_GROUP_BY_TERMS = exports.MAX_GROUPS = exports.MAX_DATA_VIEW_FIELD_DESCRIPTION_LENGTH = exports.ES_QUERY_MAX_HITS_PER_EXECUTION = exports.Comparator = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Max length for the custom field description
 */
const MAX_DATA_VIEW_FIELD_DESCRIPTION_LENGTH = exports.MAX_DATA_VIEW_FIELD_DESCRIPTION_LENGTH = 300;
const MAX_SELECTABLE_SOURCE_FIELDS = exports.MAX_SELECTABLE_SOURCE_FIELDS = 5;
const MAX_SELECTABLE_GROUP_BY_TERMS = exports.MAX_SELECTABLE_GROUP_BY_TERMS = 4;
const ES_QUERY_MAX_HITS_PER_EXECUTION = exports.ES_QUERY_MAX_HITS_PER_EXECUTION = 10000;
const MAX_GROUPS = exports.MAX_GROUPS = 1000;
let Comparator = exports.Comparator = /*#__PURE__*/function (Comparator) {
  Comparator["GT"] = ">";
  Comparator["LT"] = "<";
  Comparator["GT_OR_EQ"] = ">=";
  Comparator["LT_OR_EQ"] = "<=";
  Comparator["BETWEEN"] = "between";
  Comparator["NOT_BETWEEN"] = "notBetween";
  return Comparator;
}({});
/**
 * All runtime field types.
 * @public
 */
const RUNTIME_FIELD_TYPES = exports.RUNTIME_FIELD_TYPES = ['keyword', 'long', 'double', 'date', 'ip', 'boolean', 'geo_point', 'composite'];
const RUNTIME_FIELD_TYPES2 = exports.RUNTIME_FIELD_TYPES2 = ['keyword', 'long', 'double', 'date', 'ip', 'boolean', 'geo_point'];