"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorScheduling = void 0;
var _i18n = require("@kbn/i18n");
var _identify_exceptions = require("../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateConnectorScheduling = async (client, connectorId, scheduling) => {
  try {
    const result = await client.transport.request({
      method: 'PUT',
      path: `/_connector/${connectorId}/_scheduling`,
      body: {
        scheduling
      }
    });
    return result;
  } catch (err) {
    if ((0, _identify_exceptions.isNotFoundException)(err)) {
      throw new Error(_i18n.i18n.translate('searchConnectors.server.connectors.scheduling.error', {
        defaultMessage: 'Could not find document'
      }));
    }
    throw err;
  }
};
exports.updateConnectorScheduling = updateConnectorScheduling;