"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exampleTexts = exports.AddDocumentsCodeExample = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tryInConsole = require("@kbn/try-in-console");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _use_kibana = require("../../hooks/use_kibana");
var _language_selector = require("../shared/language_selector");
var _use_elasticsearch_url = require("../../hooks/use_elasticsearch_url");
var _usage_tracker_context = require("../../contexts/usage_tracker_context");
var _code_examples = require("../../code_examples");
var _constants = require("../../analytics/constants");
var _code_sample = require("../shared/code_sample");
var _document_generation = require("../../utils/document_generation");
var _language = require("../../utils/language");
var _guide_selector = require("../shared/guide_selector");
var _use_workflow = require("../shared/hooks/use_workflow");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_indices/public/components/index_documents/add_documents_code_example.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const exampleTexts = exports.exampleTexts = ['Yellowstone National Park is one of the largest national parks in the United States. It ranges from the Wyoming to Montana and Idaho, and contains an area of 2,219,791 acress across three different states. Its most famous for hosting the geyser Old Faithful and is centered on the Yellowstone Caldera, the largest super volcano on the American continent. Yellowstone is host to hundreds of species of animal, many of which are endangered or threatened. Most notably, it contains free-ranging herds of bison and elk, alongside bears, cougars and wolves. The national park receives over 4.5 million visitors annually and is a UNESCO World Heritage Site.', 'Yosemite National Park is a United States National Park, covering over 750,000 acres of land in California. A UNESCO World Heritage Site, the park is best known for its granite cliffs, waterfalls and giant sequoia trees. Yosemite hosts over four million visitors in most years, with a peak of five million visitors in 2016. The park is home to a diverse range of wildlife, including mule deer, black bears, and the endangered Sierra Nevada bighorn sheep. The park has 1,200 square miles of wilderness, and is a popular destination for rock climbers, with over 3,000 feet of vertical granite to climb. Its most famous and cliff is the El Capitan, a 3,000 feet monolith along its tallest face.', 'Rocky Mountain National Park  is one of the most popular national parks in the United States. It receives over 4.5 million visitors annually, and is known for its mountainous terrain, including Longs Peak, which is the highest peak in the park. The park is home to a variety of wildlife, including elk, mule deer, moose, and bighorn sheep. The park is also home to a variety of ecosystems, including montane, subalpine, and alpine tundra. The park is a popular destination for hiking, camping, and wildlife viewing, and is a UNESCO World Heritage Site.'];
const AddDocumentsCodeExample = ({
  indexName,
  mappingProperties
}) => {
  const {
    application,
    share,
    console: consolePlugin,
    cloud
  } = (0, _use_kibana.useKibana)().services;
  const elasticsearchUrl = (0, _use_elasticsearch_url.useElasticsearchUrl)();
  const usageTracker = (0, _usage_tracker_context.useUsageTracker)();
  const indexHasMappings = Object.keys(mappingProperties).length > 0;
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(_language.getDefaultCodingLanguage);
  const {
    selectedWorkflowId,
    setSelectedWorkflowId,
    ingestExamples
  } = (0, _use_workflow.useWorkflow)();
  const selectedCodeExamples = ingestExamples[selectedLanguage];
  const codeSampleMappings = indexHasMappings ? mappingProperties : ingestExamples.defaultMapping;
  const onSelectLanguage = (0, _react.useCallback)(value => {
    setSelectedLanguage(value);
    usageTracker.count([_constants.AnalyticsEvents.indexDetailsCodeLanguageSelect, `${_constants.AnalyticsEvents.indexDetailsCodeLanguageSelect}_${value}`]);
  }, [usageTracker]);
  const sampleDocuments = (0, _react.useMemo)(() => {
    return exampleTexts.map(text => (0, _document_generation.generateSampleDocument)(codeSampleMappings, text));
  }, [codeSampleMappings]);
  const {
    apiKey
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const codeParams = (0, _react.useMemo)(() => {
    var _cloud$isServerlessEn;
    return {
      indexName,
      elasticsearchURL: elasticsearchUrl,
      sampleDocuments,
      indexHasMappings,
      mappingProperties: codeSampleMappings,
      apiKey: apiKey || undefined,
      isServerless: (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : undefined
    };
  }, [indexName, elasticsearchUrl, sampleDocuments, codeSampleMappings, indexHasMappings, apiKey, cloud]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "m",
    "data-test-subj": "SearchIndicesAddDocumentsCode",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, !indexHasMappings && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.searchIndices.guideSelectors.selectGuideTitle', {
    defaultMessage: 'Select a workflow guide'
  })))), !indexHasMappings && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_guide_selector.GuideSelector, {
    selectedWorkflowId: selectedWorkflowId,
    onChange: workflowId => {
      setSelectedWorkflowId(workflowId);
      usageTracker.click([_constants.AnalyticsEvents.indexDetailsWorkflowSelect, `${_constants.AnalyticsEvents.indexDetailsWorkflowSelect}_${workflowId}`]);
    },
    showTour: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      maxWidth: '300px'
    },
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_language_selector.LanguageSelector, {
    options: _code_examples.LanguageOptions,
    selectedLanguage: selectedLanguage,
    onSelectLanguage: onSelectLanguage,
    showLabel: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    request: !indexHasMappings ? `${ingestExamples.sense.updateMappingsCommand(codeParams)}\n\n${ingestExamples.sense.ingestCommand(codeParams)}` : ingestExamples.sense.ingestCommand(codeParams),
    application: application,
    sharePlugin: share,
    consolePlugin: consolePlugin,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  })))), selectedCodeExamples.installCommand && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    id: "installCodeExample",
    title: ingestExamples.installTitle,
    description: ingestExamples.installDescription,
    language: "shell",
    code: selectedCodeExamples.installCommand,
    onCodeCopyClick: () => {
      usageTracker.click([_constants.AnalyticsEvents.indexDetailsInstallCodeCopy, `${_constants.AnalyticsEvents.indexDetailsInstallCodeCopy}_${selectedLanguage}`]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  })), !indexHasMappings && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    id: "addMappingsCodeExample",
    title: ingestExamples.addMappingsTitle,
    description: ingestExamples.addMappingsDescription,
    language: _code_examples.Languages[selectedLanguage].codeBlockLanguage,
    code: selectedCodeExamples.updateMappingsCommand(codeParams),
    onCodeCopyClick: () => {
      usageTracker.click([_constants.AnalyticsEvents.indexDetailsAddMappingsCodeCopy, `${_constants.AnalyticsEvents.indexDetailsAddMappingsCodeCopy}_${selectedLanguage}`]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_code_sample.CodeSample, {
    id: "ingestDataCodeExample",
    title: _i18n.i18n.translate('xpack.searchIndices.indexDetails.ingestDocuments.title', {
      defaultMessage: 'Ingest documents'
    }),
    description: _i18n.i18n.translate('xpack.searchIndices.indexDetails.ingestDocuments.description', {
      defaultMessage: 'Next, use the Elasticsearch bulk API to ingest an array of documents into the index.'
    }),
    language: _code_examples.Languages[selectedLanguage].codeBlockLanguage,
    code: selectedCodeExamples.ingestCommand(codeParams),
    onCodeCopyClick: () => {
      usageTracker.click([_constants.AnalyticsEvents.indexDetailsIngestDocumentsCodeCopy, `${_constants.AnalyticsEvents.indexDetailsIngestDocumentsCodeCopy}_${selectedLanguage}`]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }))));
};
exports.AddDocumentsCodeExample = AddDocumentsCodeExample;