"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatelessDocumentCountStat = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _quick_stat = require("./quick_stat");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_indices/public/components/quick_stats/stateless_document_cout_stat.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatelessDocumentCountStat = ({
  index,
  documentCount,
  open,
  setOpen
}) => {
  var _index$size;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_quick_stat.QuickStat, {
    open: open,
    setOpen: setOpen,
    icon: "documents",
    iconColor: euiTheme.colors.fullShade,
    title: _constants.DOCUMENT_COUNT_LABEL,
    "data-test-subj": "QuickStatsDocumentCount",
    secondaryTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: documentCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 23
      }
    }),
    stats: [{
      title: _constants.TOTAL_COUNT_LABEL,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: documentCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 24
        }
      })
    }, {
      title: _constants.INDEX_SIZE_LABEL,
      description: (_index$size = index.size) !== null && _index$size !== void 0 ? _index$size : '0b'
    }],
    tooltipContent: _constants.DOCUMENT_COUNT_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
};
exports.StatelessDocumentCountStat = StatelessDocumentCountStat;