"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToDiscover = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DISCOVER_LOCATOR_ID = 'DISCOVER_APP_LOCATOR';
const useNavigateToDiscover = indexName => {
  const {
    share
  } = (0, _use_kibana.useKibana)().services;
  return (0, _react.useCallback)(async () => {
    const discoverLocator = share.url.locators.get(DISCOVER_LOCATOR_ID);
    if (discoverLocator && indexName) {
      await discoverLocator.navigate({
        dataViewSpec: {
          title: indexName
        }
      });
    }
  }, [share, indexName]);
};
exports.useNavigateToDiscover = useNavigateToDiscover;