"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchNavigationPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _classic_navigation = require("./classic_navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SearchNavigationPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "currentChromeStyle", undefined);
    (0, _defineProperty2.default)(this, "coreStart", undefined);
    (0, _defineProperty2.default)(this, "pluginsStart", undefined);
    (0, _defineProperty2.default)(this, "onAppMountHandlers", []);
    (0, _defineProperty2.default)(this, "chromeSub", void 0);
    (0, _defineProperty2.default)(this, "baseClassicNavItems", []);
    this.initializerContext = initializerContext;
    this.logger = this.initializerContext.logger.get();
  }
  setup(_core) {
    return {};
  }
  start(core, plugins) {
    this.coreStart = core;
    this.pluginsStart = plugins;
    this.chromeSub = core.chrome.getChromeStyle$().subscribe(value => {
      this.currentChromeStyle = value;
    });

    // Async loads classic nav items on start
    Promise.resolve().then(() => _interopRequireWildcard(require('./base_classic_navigation_items'))).then(({
      BaseClassicNavItems
    }) => {
      // caches nav items so we don't need to do an async call when needed by other plugins.
      this.baseClassicNavItems = BaseClassicNavItems;
    });
    return {
      handleOnAppMount: this.handleOnAppMount.bind(this),
      registerOnAppMountHandler: this.registerOnAppMountHandler.bind(this),
      getBaseClassicNavItems: this.getBaseClassicNavItems.bind(this),
      useClassicNavigation: this.useClassicNavigation.bind(this),
      breadcrumbs: {
        setSearchBreadCrumbs: this.setBreadcrumbs.bind(this),
        clearBreadcrumbs: this.clearBreadcrumbs.bind(this)
      }
    };
  }
  stop() {
    if (this.chromeSub) {
      this.chromeSub.unsubscribe();
      this.chromeSub = undefined;
    }
  }
  async handleOnAppMount() {
    if (this.onAppMountHandlers.length === 0) return;
    try {
      await Promise.all(this.onAppMountHandlers);
    } catch (e) {
      this.logger.warn('Error handling app mount functions for search navigation');
      this.logger.warn(e);
    }
  }
  registerOnAppMountHandler(handler) {
    this.onAppMountHandlers.push(handler);
  }
  useClassicNavigation(history) {
    if (this.coreStart === undefined || this.currentChromeStyle !== 'classic') return undefined;
    return (0, _classic_navigation.classicNavigationFactory)(this.baseClassicNavItems, this.coreStart, history);
  }
  getBaseClassicNavItems() {
    return this.baseClassicNavItems;
  }
  setBreadcrumbs(breadcrumbs, {
    forClassicChromeStyle = false
  } = {}) {
    var _this$pluginsStart;
    if (forClassicChromeStyle === true && this.currentChromeStyle !== 'classic') return;
    if ((_this$pluginsStart = this.pluginsStart) !== null && _this$pluginsStart !== void 0 && _this$pluginsStart.serverless) {
      this.pluginsStart.serverless.setBreadcrumbs(breadcrumbs);
    } else {
      var _this$coreStart;
      const searchBreadcrumbs = [this.getSearchHomeBreadcrumb(), ...breadcrumbs];
      (_this$coreStart = this.coreStart) === null || _this$coreStart === void 0 ? void 0 : _this$coreStart.chrome.setBreadcrumbs(searchBreadcrumbs, {
        project: {
          value: breadcrumbs,
          absolute: true
        }
      });
    }
  }
  clearBreadcrumbs() {
    var _this$pluginsStart2;
    if ((_this$pluginsStart2 = this.pluginsStart) !== null && _this$pluginsStart2 !== void 0 && _this$pluginsStart2.serverless) {
      this.pluginsStart.serverless.setBreadcrumbs([]);
    } else {
      var _this$coreStart2;
      (_this$coreStart2 = this.coreStart) === null || _this$coreStart2 === void 0 ? void 0 : _this$coreStart2.chrome.setBreadcrumbs([]);
    }
  }
  getSearchHomeBreadcrumb() {
    var _this$coreStart3, _this$coreStart3$chro;
    // home deep link for this breadcrumb's path.
    const homeHref = (_this$coreStart3 = this.coreStart) === null || _this$coreStart3 === void 0 ? void 0 : (_this$coreStart3$chro = _this$coreStart3.chrome.navLinks.get(_deeplinksSearch.SEARCH_HOMEPAGE)) === null || _this$coreStart3$chro === void 0 ? void 0 : _this$coreStart3$chro.href;
    return {
      text: _i18n.i18n.translate('xpack.searchNavigation.breadcrumbs.home.title', {
        defaultMessage: 'Elasticsearch'
      }),
      href: homeHref
    };
  }
}
exports.SearchNavigationPlugin = SearchNavigationPlugin;