"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummarizationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _use_llms_models = require("../../hooks/use_llms_models");
var _include_citations_field = require("./include_citations_field");
var _instructions_field = require("./instructions_field");
var _types = require("../../types");
var _summarization_model = require("./summarization_model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/summarization_panel/summarization_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SummarizationPanel = () => {
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  const models = (0, _use_llms_models.useLLMsModels)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "summarizationPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _types.PlaygroundFormFields.summarizationModel,
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_summarization_model.SummarizationModel, {
      selectedModel: field.value,
      onSelect: model => field.onChange(model),
      models: models,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _types.PlaygroundFormFields.prompt,
    control: control,
    defaultValue: "You are an assistant for question-answering tasks.",
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_instructions_field.InstructionsField, {
      value: field.value,
      onChange: field.onChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 32
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: _types.PlaygroundFormFields.citations,
    control: control,
    defaultValue: true,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_include_citations_field.IncludeCitationsField, {
      checked: field.value,
      onChange: field.onChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
};
exports.SummarizationPanel = SummarizationPanel;