"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.synonymsStringToOption = exports.synonymsOptionToString = exports.synonymToComboBoxOption = exports.isPermissionError = exports.isExplicitSynonym = exports.getExplicitSynonym = exports.formatSynonymsSetName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isExplicitSynonym = synonym => {
  return synonym.trim().includes('=>');
};
exports.isExplicitSynonym = isExplicitSynonym;
const getExplicitSynonym = synonym => {
  return {
    mapFromString: synonym.split('=>')[0].trim(),
    mapToString: synonym.split('=>')[1].trim()
  };
};
exports.getExplicitSynonym = getExplicitSynonym;
const formatSynonymsSetName = rawName => rawName.trim().replace(/[^a-zA-Z0-9]+/g, '-') // Replace all special/non-alphanumerical characters with dashes
.replace(/^[-]+|[-]+$/g, '') // Strip all leading and trailing dashes
.toLowerCase();
exports.formatSynonymsSetName = formatSynonymsSetName;
const synonymToComboBoxOption = synonymString => {
  const isExplicit = isExplicitSynonym(synonymString);
  if (!isExplicit) {
    return {
      parsedFromTerms: synonymsStringToOption(synonymString),
      parsedToTermsString: '',
      parsedIsExplicit: isExplicit
    };
  } else {
    const {
      mapFromString,
      mapToString
    } = getExplicitSynonym(synonymString);
    return {
      parsedFromTerms: synonymsStringToOption(mapFromString),
      parsedToTermsString: mapToString,
      parsedIsExplicit: isExplicit
    };
  }
};
exports.synonymToComboBoxOption = synonymToComboBoxOption;
const synonymsStringToOption = synonyms => synonyms.length === 0 ? [] : synonyms.trim().split(',').map((s, index) => ({
  label: s,
  key: index + '-' + s.trim()
}));
exports.synonymsStringToOption = synonymsStringToOption;
const synonymsOptionToString = ({
  fromTerms,
  toTerms,
  isExplicit
}) => `${fromTerms.map(s => s.label).join(',')}${isExplicit ? ' => ' + toTerms.trim() : ''}`;
exports.synonymsOptionToString = synonymsOptionToString;
const isPermissionError = error => {
  return error.body.statusCode === 403;
};
exports.isPermissionError = isPermissionError;