"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSynonymsSetExists = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSynonymsSetExists = async (client, synonymsSetId) => {
  try {
    await client.synonyms.getSynonym({
      id: synonymsSetId
    });
    return true;
  } catch (e) {
    if (e.statusCode === 404) {
      return false;
    }
    throw e;
  }
};
exports.fetchSynonymsSetExists = fetchSynonymsSetExists;