"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSharedDetailsStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSharedDetailsStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    shardDetails: (0, _react.css)`
      line-height: 1;
      overflow-wrap: break-word;

      h3 {
        font-size: ${(0, _eui.useEuiFontSize)('m').fontSize};
      }

      &:disabled {
        text-decoration: none !important;
        cursor: default;
      }
    `,
    shardDetailsDim: (0, _react.css)`
      small {
        color: ${euiTheme.colors.darkShade};
      }
    `
  };
};
exports.useSharedDetailsStyles = useSharedDetailsStyles;