"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiActions = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _coreSecurityServer = require("@kbn/core-security-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ApiActions {
  constructor() {
    (0, _defineProperty2.default)(this, "prefix", void 0);
    this.prefix = `api:`;
  }
  isValidOperation(operation) {
    return Object.values(_coreSecurityServer.ApiOperation).includes(operation);
  }
  actionFromRouteTag(routeTag) {
    const [operation, subject] = routeTag.split('_');
    if (!this.isValidOperation(operation)) {
      throw new Error('operation is required and must be a valid ApiOperation');
    }
    return this.get(operation, subject);
  }
  get(operation, subject) {
    if (arguments.length === 1) {
      if (!(0, _lodash.isString)(operation) || !operation) {
        throw new Error('operation is required and must be a string');
      }
      return `${this.prefix}${operation}`;
    }
    if (!(0, _lodash.isString)(subject) || !subject) {
      throw new Error('subject is required and must be a string');
    }
    if (!this.isValidOperation(operation)) {
      throw new Error('operation is required and must be a valid ApiOperation');
    }
    return `${this.prefix}${operation}_${subject}`;
  }
}
exports.ApiActions = ApiActions;