"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSpaceForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _securityUiComponents = require("@kbn/security-ui-components");
var _space_selector = require("./space_selector");
var _constants = require("../../../../../../../common/constants");
var _model = require("../../../../../../../common/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/kibana/space_aware_privilege_section/privilege_space_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class PrivilegeSpaceForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "getForm", () => {
      const {
        spaces
      } = this.props;
      const hasSelectedSpaces = this.state.selectedSpaceIds.length > 0;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        label: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.spaceSelectorFormLabel', {
          defaultMessage: 'Select spaces'
        }),
        helpText: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.spaceSelectorFormHelpText', {
          defaultMessage: 'Users assigned to this role will gain access to selected spaces.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_space_selector.SpaceSelector, {
        selectedSpaceIds: this.state.selectedSpaceIds,
        onChange: this.onSelectedSpacesChange,
        spaces: spaces,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 11
        }
      })), Boolean(this.state.selectedSpaceIds.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "primary",
        iconType: "info",
        size: "s",
        title: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.privilegeCombinationMsg.title', {
          defaultMessage: `The user's resulting access depends on a combination of their role's global space privileges and specific privileges applied to this space.`
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        label: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.privilegeSelectorFormLabel', {
          defaultMessage: 'Define privileges'
        }),
        helpText: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.privilegeSelectorFormHelpText', {
          defaultMessage: 'Assign the privilege level you wish to grant to all present and future features across this space.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        name: `basePrivilegeButtonGroup`,
        "data-test-subj": `basePrivilegeButtonGroup`,
        isFullWidth: true,
        color: 'primary',
        options: [{
          id: 'basePrivilege_all',
          label: 'All',
          ['data-test-subj']: 'basePrivilege_all'
        }, {
          id: 'basePrivilege_read',
          label: 'Read',
          ['data-test-subj']: 'basePrivilege_read'
        }, {
          id: 'basePrivilege_custom',
          label: 'Customize',
          ['data-test-subj']: 'basePrivilege_custom'
        }],
        idSelected: this.getDisplayedBasePrivilege(),
        isDisabled: !hasSelectedSpaces,
        onChange: this.onSpaceBasePrivilegeChange,
        legend: _i18n.i18n.translate('xpack.security.management.editRole.spacePrivilegeForm.basePrivilegeControlLegend', {
          defaultMessage: 'Privileges for all features'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_securityUiComponents.KibanaPrivilegeTable, {
        role: this.state.role,
        privilegeCalculator: this.state.privilegeCalculator,
        onChange: this.onFeaturePrivilegesChange,
        onChangeAll: this.onChangeAllFeaturePrivileges,
        kibanaPrivileges: this.props.kibanaPrivileges,
        privilegeIndex: this.state.privilegeIndex,
        showAdditionalPermissionsMessage: true,
        canCustomizeSubFeaturePrivileges: this.props.canCustomizeSubFeaturePrivileges,
        disabled: this.state.selectedBasePrivilege.length > 0 || !hasSelectedSpaces,
        allSpacesSelected: this.state.selectedSpaceIds.includes(_constants.ALL_SPACES_ID),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 263,
          columnNumber: 13
        }
      })));
    });
    (0, _defineProperty2.default)(this, "getSaveButton", () => {
      const {
        mode
      } = this.state;
      let buttonText;
      switch (mode) {
        case 'create':
          buttonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRolespacePrivilegeForm.createPrivilegeButton",
            defaultMessage: "Assign role",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 287,
              columnNumber: 11
            }
          });
          break;
        case 'update':
          buttonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRolespacePrivilegeForm.updatePrivilegeButton",
            defaultMessage: "Update role privileges",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 295,
              columnNumber: 11
            }
          });
          break;
        default:
          throw new Error(`Unsupported mode: ${mode}`);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.onSaveClick,
        fill: true,
        disabled: !this.canSave(),
        color: "primary",
        "data-test-subj": 'createSpacePrivilegeButton',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 7
        }
      }, buttonText);
    });
    (0, _defineProperty2.default)(this, "closeFlyout", () => {
      this.props.onCancel();
    });
    (0, _defineProperty2.default)(this, "onSaveClick", () => {
      const role = (0, _model.copyRole)(this.state.role);
      const form = role.kibana[this.state.privilegeIndex];

      // remove any spaces that no longer exist
      if (!this.isDefiningGlobalPrivilege()) {
        form.spaces = form.spaces.filter(spaceId => this.props.spaces.find(space => space.id === spaceId));
      }
      this.props.onChange(role);
    });
    (0, _defineProperty2.default)(this, "onSelectedSpacesChange", selectedSpaceIds => {
      const role = (0, _model.copyRole)(this.state.role);
      const form = role.kibana[this.state.privilegeIndex];
      form.spaces = [...selectedSpaceIds];
      form.feature = this.resetRoleFeature(form.feature, selectedSpaceIds); // Remove any feature privilege(s) that cannot currently be selected

      this.setState({
        selectedSpaceIds,
        role,
        privilegeCalculator: new _securityUiComponents.PrivilegeFormCalculator(this.props.kibanaPrivileges, role)
      });
    });
    (0, _defineProperty2.default)(this, "onSpaceBasePrivilegeChange", basePrivilege => {
      const role = (0, _model.copyRole)(this.state.role);
      const form = role.kibana[this.state.privilegeIndex];
      const privilegeName = basePrivilege.split('basePrivilege_')[1];
      let isCustomizingFeaturePrivileges = false;
      if (privilegeName === _securityUiComponents.constants.CUSTOM_PRIVILEGE_VALUE) {
        form.base = [];
        isCustomizingFeaturePrivileges = true;
      } else {
        form.base = [privilegeName];
        form.feature = {};
      }
      this.setState({
        selectedBasePrivilege: privilegeName === _securityUiComponents.constants.CUSTOM_PRIVILEGE_VALUE ? [] : [privilegeName],
        role,
        isCustomizingFeaturePrivileges,
        privilegeCalculator: new _securityUiComponents.PrivilegeFormCalculator(this.props.kibanaPrivileges, role)
      });
    });
    (0, _defineProperty2.default)(this, "resetRoleFeature", (roleFeature, selectedSpaceIds) => {
      const securedFeatures = this.props.kibanaPrivileges.getSecuredFeatures();
      return Object.entries(roleFeature).reduce((features, [featureId, privileges]) => {
        var _securedFeature$getPr;
        if (!Array.isArray(privileges)) {
          return features;
        }
        const securedFeature = securedFeatures.find(sf => sf.id === featureId);
        const primaryFeaturePrivilege = (_securedFeature$getPr = securedFeature === null || securedFeature === void 0 ? void 0 : securedFeature.getPrimaryFeaturePrivileges({
          includeMinimalFeaturePrivileges: true
        }).find(pfp => privileges.includes(pfp.id))) !== null && _securedFeature$getPr !== void 0 ? _securedFeature$getPr : {
          disabled: false,
          requireAllSpaces: false
        };
        const areAllSpacesSelected = selectedSpaceIds.includes(_constants.ALL_SPACES_ID);
        if (securedFeature) {
          securedFeature.getSubFeatures().forEach(subFeature => {
            subFeature.privileges.forEach(currentPrivilege => {
              if (privileges.includes(currentPrivilege.id)) {
                if (subFeature.requireAllSpaces && !areAllSpacesSelected) {
                  (0, _lodash.remove)(privileges, privilege => privilege === currentPrivilege.id);
                }
              }
            });
          });
        }
        const newFeaturePrivileges = primaryFeaturePrivilege !== null && primaryFeaturePrivilege !== void 0 && primaryFeaturePrivilege.disabled || primaryFeaturePrivilege !== null && primaryFeaturePrivilege !== void 0 && primaryFeaturePrivilege.requireAllSpaces && !areAllSpacesSelected ? [] // The primary feature privilege cannot be selected; remove that and any selected sub-feature privileges, too
        : privileges;
        return {
          ...features,
          ...(newFeaturePrivileges.length && {
            [featureId]: newFeaturePrivileges
          })
        };
      }, {});
    });
    (0, _defineProperty2.default)(this, "getDisplayedBasePrivilege", () => {
      const basePrivilege = this.state.privilegeCalculator.getBasePrivilege(this.state.privilegeIndex);
      if (basePrivilege) {
        return `basePrivilege_${basePrivilege.id}`;
      }
      return `basePrivilege_${_securityUiComponents.constants.CUSTOM_PRIVILEGE_VALUE}`;
    });
    (0, _defineProperty2.default)(this, "onFeaturePrivilegesChange", (featureId, privileges) => {
      this.setRole(privileges, featureId);
    });
    (0, _defineProperty2.default)(this, "onChangeAllFeaturePrivileges", privileges => {
      this.setRole(privileges);
    });
    (0, _defineProperty2.default)(this, "canSave", () => {
      if (this.state.selectedSpaceIds.length === 0) {
        return false;
      }
      const form = this.state.role.kibana[this.state.privilegeIndex];
      return !(form.base.length === 0 && Object.keys(form.feature).length === 0);
    });
    (0, _defineProperty2.default)(this, "isDefiningGlobalPrivilege", () => this.state.selectedSpaceIds.includes('*'));
    const _role = (0, _model.copyRole)(props.role);
    let privilegeIndex = props.privilegeIndex;
    if (privilegeIndex < 0) {
      // create new form
      privilegeIndex = _role.kibana.push({
        spaces: [],
        base: [],
        feature: {}
      }) - 1;
    }
    this.state = {
      role: _role,
      privilegeIndex,
      selectedSpaceIds: [..._role.kibana[privilegeIndex].spaces],
      selectedBasePrivilege: [...(_role.kibana[privilegeIndex].base || [])],
      mode: props.privilegeIndex < 0 ? 'create' : 'update',
      isCustomizingFeaturePrivileges: false,
      privilegeCalculator: new _securityUiComponents.PrivilegeFormCalculator(props.kibanaPrivileges, _role)
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      onClose: this.closeFlyout,
      size: "m",
      maxWidth: true,
      maskProps: {
        headerZindexLocation: 'below'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }, this.state.mode === 'create' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeForm.modalTitleCreate",
      defaultMessage: "Assign role to spaces",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeForm.modalTitleUpdate",
      defaultMessage: "Edit role privileges for spaces",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    }, this.getForm())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, this.state.privilegeCalculator.hasSupersededInheritedPrivileges(this.state.privilegeIndex) && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "warning",
      "data-test-subj": "spaceFormGlobalPermissionsSupersedeWarning",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.spacePrivilegeForm.supersededWarningTitle",
        defaultMessage: "Superseded by global privileges",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 19
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeForm.supersededWarning",
      defaultMessage: "Declared privileges are less permissive than configured global privileges. View the privilege summary to see effective privileges.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      onClick: this.closeFlyout,
      flush: "left",
      "data-test-subj": 'cancelSpacePrivilegeButton',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.spacePrivilegeForm.cancelButton",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 13
      }
    }, this.getSaveButton()))));
  }
  setRole(privileges, featureId) {
    const role = (0, _model.copyRole)(this.state.role);
    const entry = role.kibana[this.state.privilegeIndex];
    if (privileges.length === 0) {
      if (featureId) {
        delete entry.feature[featureId];
      } else {
        entry.feature = {};
      }
    } else {
      let securedFeaturesToSet = this.props.kibanaPrivileges.getSecuredFeatures();
      if (featureId) {
        securedFeaturesToSet = [securedFeaturesToSet.find(sf => sf.id === featureId)];
      }
      securedFeaturesToSet.forEach(feature => {
        const nextFeaturePrivilege = feature.getPrimaryFeaturePrivileges({
          includeMinimalFeaturePrivileges: true
        }).find(pfp => {
          if (pfp !== null && pfp !== void 0 && pfp.disabled || pfp !== null && pfp !== void 0 && pfp.requireAllSpaces && !this.state.selectedSpaceIds.includes(_constants.ALL_SPACES_ID)) {
            return false;
          }
          return Array.isArray(privileges) && privileges.includes(pfp.id);
        });
        let newPrivileges = [];
        if (nextFeaturePrivilege) {
          newPrivileges = [nextFeaturePrivilege.id];
          feature.getSubFeaturePrivileges().forEach(psf => {
            if (Array.isArray(privileges) && privileges.includes(psf.id)) {
              if (!psf.requireAllSpaces || psf.requireAllSpaces && this.state.selectedSpaceIds.includes(_constants.ALL_SPACES_ID)) {
                newPrivileges.push(psf.id);
              }
            }
          });
        }
        if (newPrivileges.length === 0) {
          delete entry.feature[feature.id];
        } else {
          entry.feature[feature.id] = newPrivileges;
        }
      });
    }
    this.setState({
      role,
      privilegeCalculator: new _securityUiComponents.PrivilegeFormCalculator(this.props.kibanaPrivileges, role)
    });
  }
}
exports.PrivilegeSpaceForm = PrivilegeSpaceForm;
(0, _defineProperty2.default)(PrivilegeSpaceForm, "defaultProps", {
  privilegeIndex: -1
});