"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesSubFeaturesMapV2 = exports.getCasesBaseKibanaSubFeatureIdsV2 = void 0;
var _product_features_keys = require("../../product_features_keys");
var _constants = require("../../constants");
var _kibana_sub_features = require("../kibana_sub_features");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sub-features that will always be available for Security Cases
 * regardless of the product type.
 */
const getCasesBaseKibanaSubFeatureIdsV2 = () => [_product_features_keys.CasesSubFeatureId.deleteCases, _product_features_keys.CasesSubFeatureId.casesSettings, _product_features_keys.CasesSubFeatureId.createComment, _product_features_keys.CasesSubFeatureId.reopenCase];

/**
 * Defines all the Security Solution Cases subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getCasesBaseKibanaSubFeatureIdsV2 = getCasesBaseKibanaSubFeatureIdsV2;
const getCasesSubFeaturesMapV2 = params => {
  const subFeaturesMap = new Map([[_product_features_keys.CasesSubFeatureId.deleteCases, (0, _kibana_sub_features.getDeleteCasesSubFeature)(params)], [_product_features_keys.CasesSubFeatureId.casesSettings, (0, _kibana_sub_features.getCasesSettingsCasesSubFeature)(params)], /* The below sub features were newly added in v2 (8.17) */
  [_product_features_keys.CasesSubFeatureId.createComment, (0, _kibana_sub_features.getCasesAddCommentsCasesSubFeature)(params)], [_product_features_keys.CasesSubFeatureId.reopenCase, (0, _kibana_sub_features.getCasesReopenCaseSubFeature)(params)]]);
  return (0, _utils.addAllSubFeatureReplacements)(subFeaturesMap, [{
    feature: _constants.CASES_FEATURE_ID_V3
  }]);
};
exports.getCasesSubFeaturesMapV2 = getCasesSubFeaturesMapV2;