"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CancelActionRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _base = require("../../common/base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CancelActionRequestBodySchema = _configSchema.schema.object({
  ..._base.BaseActionRequestSchema,
  parameters: _configSchema.schema.object({
    id: _configSchema.schema.string({
      minLength: 1,
      validate: value => {
        if (!value.trim().length) {
          return 'id cannot be an empty string';
        }
      }
    })
  })
});
const CancelActionRequestSchema = exports.CancelActionRequestSchema = {
  body: CancelActionRequestBodySchema
};