"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityAnalyticsEntityTypes = exports.getEnabledEntityTypes = exports.getAlertsIndex = void 0;
var _constants = require("../constants");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_ANALYTICS_ENTITY_TYPES = [_types.EntityType.user, _types.EntityType.host, _types.EntityType.service];
const getEntityAnalyticsEntityTypes = () => ENTITY_ANALYTICS_ENTITY_TYPES;
exports.getEntityAnalyticsEntityTypes = getEntityAnalyticsEntityTypes;
const getEnabledEntityTypes = genericDefinitionEnabled => {
  const entities = Object.values(_types.EntityType);
  if (genericDefinitionEnabled) {
    return entities;
  }

  // Remove the index of generic
  entities.splice(entities.indexOf(_types.EntityType.generic), 1);
  return entities;
};
exports.getEnabledEntityTypes = getEnabledEntityTypes;
const getAlertsIndex = (spaceId = 'default') => `${_constants.DEFAULT_ALERTS_INDEX}-${spaceId}`;
exports.getAlertsIndex = getAlertsIndex;