"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateMigrationDashboard = exports.OriginalDashboardVendor = exports.OriginalDashboard = exports.ElasticDashboardPartial = exports.ElasticDashboard = exports.DashboardMigrationTranslationStats = exports.DashboardMigrationTaskStats = exports.DashboardMigrationTaskExecutionSettings = exports.DashboardMigrationRetryFilterEnum = exports.DashboardMigrationRetryFilter = exports.DashboardMigrationData = exports.DashboardMigrationDashboardData = exports.DashboardMigrationDashboard = exports.DashboardMigration = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("../../api/model/primitives.gen");
var _common = require("./common.gen");
var _splunk = require("./vendor/dashboards/splunk.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: SIEM Dashboard Migration components
 *   version: not applicable
 */

/**
 * The original dashboard vendor identifier.
 */

const OriginalDashboardVendor = exports.OriginalDashboardVendor = _zod.z.literal('splunk');

/**
 * The dashboard migration object ( without Id ) with its settings.
 */

const DashboardMigrationData = exports.DashboardMigrationData = _zod.z.object({
  /**
   * The dashboard migration name
   */
  name: _primitives.NonEmptyString,
  /**
   * The user profile ID of the user who created the migration.
   */
  created_by: _primitives.NonEmptyString,
  /**
   * The moment migration was created
   */
  created_at: _primitives.NonEmptyString,
  /**
   * The last execution of the dashboard migration task.
   */
  last_execution: _common.MigrationLastExecution.optional()
});

/**
 * The dashboard migration object with its settings.
 */

const DashboardMigration = exports.DashboardMigration = _zod.z.object({
  /**
   * The dashboard migration id
   */
  id: _primitives.NonEmptyString
}).merge(DashboardMigrationData);

/**
 * The dashboard migration translation stats object.
 */

const DashboardMigrationTranslationStats = exports.DashboardMigrationTranslationStats = _zod.z.object({
  /**
   * The migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The dashboards migration translation stats.
   */
  dashboards: _zod.z.object({
    /**
     * The total number of dashboards in the migration.
     */
    total: _zod.z.number().int(),
    /**
     * The number of dashboards that have been successfully translated.
     */
    success: _zod.z.object({
      /**
       * The total number of dashboards that have been successfully translated.
       */
      total: _zod.z.number().int(),
      /**
       * The translation results
       */
      result: _zod.z.object({
        /**
         * The number of dashboards that have been fully translated.
         */
        full: _zod.z.number().int(),
        /**
         * The number of dashboards that have been partially translated.
         */
        partial: _zod.z.number().int(),
        /**
         * The number of dashboards that could not be translated.
         */
        untranslatable: _zod.z.number().int()
      }),
      /**
       * The number of dashboards that have been successfully translated and can be installed.
       */
      installable: _zod.z.number().int()
    }),
    /**
     * The number of dashboards that have failed translation.
     */
    failed: _zod.z.number().int()
  })
});

/**
 * The raw dashboard object from different vendors
 */

const OriginalDashboard = exports.OriginalDashboard = _zod.z.object({
  /**
   * The unique identifier for the dashboard
   */
  id: _zod.z.string(),
  /**
   * The original dashboard vendor identifier.
   */
  vendor: OriginalDashboardVendor,
  /**
   * The title of the dashboard
   */
  title: _zod.z.string(),
  /**
   * The description of the dashboard
   */
  description: _zod.z.string(),
  /**
   * The data of the dashboard in the specified format
   */
  data: _zod.z.string(),
  /**
   * The last updated timestamp of the dashboard
   */
  last_updated: _zod.z.string().optional(),
  /**
   * The format of the dashboard data (e.g., 'json', 'xml')
   */
  format: _zod.z.string(),
  /**
   * Additional properties specific to the splunk
   */
  splunk_properties: _splunk.SplunkOriginalDashboardProperties.optional()
});

/**
 * The elastic dashboard translation.
 */

const ElasticDashboard = exports.ElasticDashboard = _zod.z.object({
  /**
   * The unique identifier for the dashboard installed Saved Object
   */
  id: _zod.z.string().optional(),
  /**
   * The title of the dashboard
   */
  title: _zod.z.string(),
  /**
   * The description of the dashboard
   */
  description: _zod.z.string().optional(),
  /**
   * The data of the dashboard, format could depend on the vendor
   */
  data: _zod.z.string().optional()
});

/**
 * The dashboard migration document object.
 */

const DashboardMigrationDashboardData = exports.DashboardMigrationDashboardData = _zod.z.object({
  /**
   * The moment of creation
   */
  '@timestamp': _zod.z.string(),
  /**
   * The migration id.
   */
  migration_id: _primitives.NonEmptyString,
  /**
   * The user profile ID of the user who created the migration.
   */
  created_by: _primitives.NonEmptyString,
  /**
   * The original dashboard to migrate.
   */
  original_dashboard: OriginalDashboard,
  /**
   * The translated elastic dashboard.
   */
  elastic_dashboard: ElasticDashboard.optional(),
  /**
   * The rule translation result.
   */
  translation_result: _common.MigrationTranslationResult.optional(),
  /**
   * The status of the dashboard migration process.
   */
  status: _common.MigrationStatus.default('pending'),
  /**
   * The comments for the migration including a summary from the LLM in markdown.
   */
  comments: _common.MigrationComments.optional(),
  /**
   * The moment of the last update
   */
  updated_at: _zod.z.string().optional(),
  /**
   * The user who last updated the migration
   */
  updated_by: _zod.z.string().optional()
});

/**
 * The dashboard migration document object.
 */

const DashboardMigrationDashboard = exports.DashboardMigrationDashboard = _zod.z.object({
  /**
   * The dashboard migration id
   */
  id: _primitives.NonEmptyString
}).merge(DashboardMigrationDashboardData);

/**
 * The partial version of the migrated elastic dashboard.
 */

const ElasticDashboardPartial = exports.ElasticDashboardPartial = ElasticDashboard.partial();

/**
 * The dashboard migration data object for dashboard update operation
 */

const UpdateMigrationDashboard = exports.UpdateMigrationDashboard = _zod.z.object({
  /**
   * The dashboard migration id
   */
  id: _primitives.NonEmptyString,
  /**
   * The migrated elastic dashboard attributes to update.
   */
  elastic_dashboard: ElasticDashboardPartial.optional(),
  /**
   * The comments for the migration including a summary from the LLM in markdown.
   */
  comments: _common.MigrationComments.optional()
});

/**
 * The dashboard migration task stats object.
 */

const DashboardMigrationTaskStats = exports.DashboardMigrationTaskStats = _common.MigrationTaskStats;

/**
 * The dashboard migration task execution settings.
 */

const DashboardMigrationTaskExecutionSettings = exports.DashboardMigrationTaskExecutionSettings = _zod.z.object({
  /**
   * The connector ID used in the last execution.
   */
  connector_id: _zod.z.string()
});

/**
 * Indicates the filter to retry the migrations dashboards translation
 */

const DashboardMigrationRetryFilter = exports.DashboardMigrationRetryFilter = _zod.z.enum(['failed', 'not_fully_translated']);
const DashboardMigrationRetryFilterEnum = exports.DashboardMigrationRetryFilterEnum = DashboardMigrationRetryFilter.enum;