"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupingTitle = exports.assetsUnit = exports.assetGroupsUnit = exports.NULL_GROUPING_UNIT = exports.NULL_GROUPING_MESSAGES = exports.GROUPING_LABELS = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetsUnit = totalCount => _i18n.i18n.translate('xpack.securitySolution.assetInventory.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {asset} other {assets}}`
});
exports.assetsUnit = assetsUnit;
const assetGroupsUnit = (totalCount, selectedGroup, hasNullGroup) => {
  const groupCount = hasNullGroup ? totalCount - 1 : totalCount;
  switch (selectedGroup) {
    case _constants.ASSET_GROUPING_OPTIONS.ASSET_CRITICALITY:
      return _i18n.i18n.translate('xpack.securitySolution.assetInventory.groupUnit.assetCriticality', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {asset criticality} other {asset criticalities}}`
      });
    case _constants.ASSET_GROUPING_OPTIONS.ENTITY_TYPE:
      return _i18n.i18n.translate('xpack.securitySolution.assetInventory.groupUnit.entityType', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {entity type} other {entity types}}`
      });
    case _constants.ASSET_GROUPING_OPTIONS.CLOUD_ACCOUNT:
      return _i18n.i18n.translate('xpack.securitySolution.assetInventory.groupUnit.cloudAccount', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {cloud account} other {cloud accounts}}`
      });
    default:
      return _i18n.i18n.translate('xpack.securitySolution.assetInventory.groupUnit.default', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {group} other {groups}}`
      });
  }
};
exports.assetGroupsUnit = assetGroupsUnit;
const NULL_GROUPING_UNIT = exports.NULL_GROUPING_UNIT = _i18n.i18n.translate('xpack.securitySolution.assetInventory.grouping.nullGroupUnit', {
  defaultMessage: 'assets'
});
const NULL_GROUPING_MESSAGES = exports.NULL_GROUPING_MESSAGES = {
  ASSET_CRITICALITY: _i18n.i18n.translate('xpack.securitySolution.assetInventory.grouping.assetCriticality.nullGroupTitle', {
    defaultMessage: 'No asset criticality'
  }),
  ENTITY_TYPE: _i18n.i18n.translate('xpack.securitySolution.assetInventory.grouping.entityType.nullGroupTitle', {
    defaultMessage: 'No entity type'
  }),
  CLOUD_ACCOUNT: _i18n.i18n.translate('xpack.securitySolution.assetInventory.grouping.cloudAccount.nullGroupTitle', {
    defaultMessage: 'No cloud account'
  }),
  DEFAULT: _i18n.i18n.translate('xpack.securitySolution.assetInventory.grouping.default.nullGroupTitle', {
    defaultMessage: 'No grouping'
  })
};
const GROUPING_LABELS = exports.GROUPING_LABELS = {
  ASSET_CRITICALITY: _i18n.i18n.translate('xpack.securitySolution.assetInventory.groupBy.assetCriticality', {
    defaultMessage: 'Asset criticality'
  }),
  ENTITY_TYPE: _i18n.i18n.translate('xpack.securitySolution.assetInventory.groupBy.entityType', {
    defaultMessage: 'Entity type'
  }),
  CLOUD_ACCOUNT: _i18n.i18n.translate('xpack.securitySolution.assetInventory.groupBy.cloudAccount', {
    defaultMessage: 'Cloud account'
  })
};
const groupingTitle = exports.groupingTitle = _i18n.i18n.translate('xpack.securitySolution.assetInventory.groupBy', {
  defaultMessage: 'Group assets by'
});