"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendToTimelineEligibleQueryTypes = exports.getRawData = exports.getPromptContextFromDetectionRules = exports.LOCAL_STORAGE_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = exports.LOCAL_STORAGE_KEY = `securityAssistant`;
const getPromptContextFromDetectionRules = rules => {
  const data = rules.map(rule => `Rule Name:${rule.name}\nRule Description:${rule.description}`);
  return data.join('\n\n');
};
exports.getPromptContextFromDetectionRules = getPromptContextFromDetectionRules;
const getRawData = data => data.filter(({
  field
}) => !field.startsWith('signal.')).reduce((acc, {
  field,
  values
}) => ({
  ...acc,
  [field]: values !== null && values !== void 0 ? values : []
}), {});
exports.getRawData = getRawData;
const sendToTimelineEligibleQueryTypes = exports.sendToTimelineEligibleQueryTypes = ['kql', 'dsl', 'eql', 'esql', 'sql' // Models often put the code block language as sql, for esql, so adding this as a fallback
];