"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuccessResultMessage = void 0;
var _get_formatted_time = require("../get_formatted_time");
var i18n = _interopRequireWildcard(require("../../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSuccessResultMessage = ({
  alertsContextCount,
  connectorName,
  discoveries,
  dateFormat,
  generationEndTime
}) => {
  var _getFormattedDate;
  const formattedGenerationEndTime = (_getFormattedDate = (0, _get_formatted_time.getFormattedDate)({
    date: generationEndTime,
    dateFormat
  })) !== null && _getFormattedDate !== void 0 ? _getFormattedDate : undefined;

  // If the count is known to be 0, show the "no matching alerts" message
  if (alertsContextCount === 0) {
    return i18n.NO_MATCHING_ALERTS_VIA({
      connectorName,
      formattedGenerationEndTime
    });
  }
  if (discoveries != null) {
    return i18n.RAN_SUCCESSFULLY_VIA_WITH_DISCOVERIES_COUNT({
      connectorName,
      discoveries,
      formattedGenerationEndTime
    });
  }
  return i18n.RAN_SUCCESSFULLY_VIA_NO_DISCOVERIES_COUNT({
    connectorName,
    formattedGenerationEndTime
  });
};
exports.getSuccessResultMessage = getSuccessResultMessage;