"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchAndFilter = exports.STEP = exports.NO_INDEX_PATTERNS = exports.MIN_ALERTS = exports.MAX_ALERTS = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _connector_filter = require("./connector_filter");
var _get_common_time_ranges = require("../../../settings_flyout/alert_selection/helpers/get_common_time_ranges");
var _status_filter = require("./status_filter");
var i18n = _interopRequireWildcard(require("./translations"));
var _visibility_filter = require("./visibility_filter");
var _use_get_attack_discovery_generations = require("../../../use_get_attack_discovery_generations");
var _use_find_attack_discoveries = require("../../../use_find_attack_discoveries");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/history/search_and_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const updateButtonProps = {
  fill: false
};
const DATE_PICKER_WIDTH = '345px';
const MAX_ALERTS = exports.MAX_ALERTS = 500;
const MIN_ALERTS = exports.MIN_ALERTS = 50;
const STEP = exports.STEP = 50;
const NO_INDEX_PATTERNS = exports.NO_INDEX_PATTERNS = [];
const box = {
  incremental: true
};
const SearchAndFilterComponent = ({
  aiConnectors,
  connectorNames,
  end,
  filterByAlertIds,
  isLoading = false,
  onRefresh,
  query,
  selectedConnectorNames,
  setEnd,
  setFilterByAlertIds,
  setQuery,
  setSelectedAttackDiscoveries,
  setSelectedConnectorNames,
  setShared,
  setStart,
  setStatusItems,
  shared,
  start,
  statusItems
}) => {
  const invalidateGetAttackDiscoveryGenerations = (0, _use_get_attack_discovery_generations.useInvalidateGetAttackDiscoveryGenerations)();
  const invalidateFindAttackDiscoveries = (0, _use_find_attack_discoveries.useInvalidateFindAttackDiscoveries)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // Users accumulate an "unsubmitted" query as they type in the search bar,
  // but have not pressed the 'Enter' key to submit the query, (which would
  // call `onQuerySubmit`).
  //
  // This unsubmitted query is stored in `unSubmittedQuery`.
  //
  // To match the behavior of Discover, `setQuery` must be called with the
  // `unSubmittedQuery` query when:
  //
  // 1) The user selects a new time range
  // 2) The user clicks the refresh button
  //
  // Also to match the behavior of Discover, we must NOT call `setQuery` with
  // the `unSubmittedQuery` query when the user clicks the `Save` button.
  const [unSubmittedQuery, setUnSubmittedQuery] = _react2.default.useState(query);

  // get the common time ranges for the date picker:
  const commonlyUsedRanges = (0, _react2.useMemo)(() => (0, _get_common_time_ranges.getCommonTimeRanges)(), []);

  /**
   * `onTimeChange` is called by the `EuiSuperDatePicker` when the user:
   * 1) selects a new time range
   * 2) clicks the refresh button
   */
  const onTimeChange = (0, _react2.useCallback)(({
    start: startDate,
    end: endDate
  }) => {
    setQuery(unSubmittedQuery);
    setStart(startDate);
    setEnd(endDate);
    invalidateFindAttackDiscoveries();
    invalidateGetAttackDiscoveryGenerations();
  }, [invalidateFindAttackDiscoveries, invalidateGetAttackDiscoveryGenerations, setEnd, setQuery, setStart, unSubmittedQuery]);

  /**
   * `onChange` is called by the `SearchBar` as the user types in the search box
   */
  const onChange = (0, _react2.useCallback)(({
    queryText
  }) => {
    setUnSubmittedQuery(queryText);
  }, []);
  const uniqueFilterIds = (0, _react2.useMemo)(() => (0, _fp.uniq)(filterByAlertIds), [filterByAlertIds]);
  const localOnRefresh = (0, _react2.useCallback)(() => {
    setQuery(unSubmittedQuery);
    setSelectedAttackDiscoveries({});
    onRefresh();
    invalidateFindAttackDiscoveries();
    invalidateGetAttackDiscoveryGenerations();
  }, [invalidateFindAttackDiscoveries, invalidateGetAttackDiscoveryGenerations, onRefresh, setQuery, setSelectedAttackDiscoveries, unSubmittedQuery]);
  const onKeyDown = (0, _react2.useCallback)(event => {
    if (event.key === 'Enter') {
      localOnRefresh();
    }
  }, [localOnRefresh]);
  const removeAlertIdFromFilter = (0, _react2.useCallback)(id => {
    setFilterByAlertIds(filterByAlertIds.filter(alertId => alertId !== id));
    invalidateFindAttackDiscoveries();
  }, [filterByAlertIds, invalidateFindAttackDiscoveries, setFilterByAlertIds]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
          gap: 16px;
        `,
    gutterSize: "none",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "searchAndFilterQueryQuery",
    onKeyDown: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSearchBar, {
    box: box,
    "data-test-subj": "searchAndFilterSearchBar",
    defaultQuery: query,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_visibility_filter.VisibilityFilter, {
    isLoading: isLoading,
    setShared: setShared,
    shared: shared,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_status_filter.StatusFilter, {
    isLoading: isLoading,
    setStatusItems: setStatusItems,
    statusItems: statusItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_connector_filter.ConnectorFilter, {
    aiConnectors: aiConnectors,
    connectorNames: connectorNames,
    isLoading: isLoading,
    selectedConnectorNames: selectedConnectorNames,
    setSelectedConnectorNames: setSelectedConnectorNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            width: ${DATE_PICKER_WIDTH};
          `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSuperDatePicker, {
    commonlyUsedRanges: commonlyUsedRanges,
    "data-test-subj": "alertSelectionDatePicker",
    end: end,
    isDisabled: isLoading,
    onRefresh: localOnRefresh,
    onTimeChange: onTimeChange,
    showUpdateButton: true,
    start: start,
    updateButtonProps: updateButtonProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  }))), filterByAlertIds.length > 0 && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
              gap: ${euiTheme.size.s};
            `,
    gutterSize: "none",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }, uniqueFilterIds.map(id => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    key: id,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    css: (0, _react.css)`
                    padding: ${euiTheme.size.s};
                  `,
    color: "hollow",
    iconSide: "right",
    iconType: "cross",
    iconOnClick: () => removeAlertIdFromFilter(id),
    iconOnClickAriaLabel: i18n.CLEAR_FILTER_ID(id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 17
    }
  }, `_id: ${id}`))))));
};
const SearchAndFilter = exports.SearchAndFilter = /*#__PURE__*/_react2.default.memo(SearchAndFilterComponent);