"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeUnitLabel = exports.getTimeOptions = exports.TIME_UNITS = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TIME_UNITS = exports.TIME_UNITS = /*#__PURE__*/function (TIME_UNITS) {
  TIME_UNITS["SECOND"] = "s";
  TIME_UNITS["MINUTE"] = "m";
  TIME_UNITS["HOUR"] = "h";
  TIME_UNITS["DAY"] = "d";
  return TIME_UNITS;
}({});
const getTimeUnitLabel = (timeUnit = TIME_UNITS.SECOND, timeValue = '0') => {
  switch (timeUnit) {
    case TIME_UNITS.SECOND:
      return i18n.SCHEDULE_TIME_UNITS_SECOND(timeValue);
    case TIME_UNITS.MINUTE:
      return i18n.SCHEDULE_TIME_UNITS_MINUTE(timeValue);
    case TIME_UNITS.HOUR:
      return i18n.SCHEDULE_TIME_UNITS_HOUR(timeValue);
    case TIME_UNITS.DAY:
      return i18n.SCHEDULE_TIME_UNITS_DAY(timeValue);
  }
};
exports.getTimeUnitLabel = getTimeUnitLabel;
const getTimeOptions = unitSize => {
  return Object.entries(TIME_UNITS).map(([_, value]) => {
    return {
      text: getTimeUnitLabel(value, unitSize.toString()),
      value
    };
  });
};
exports.getTimeOptions = getTimeOptions;