"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseEventsDataView = void 0;
var _react = require("react");
var _public = require("@kbn/data-views-plugin/public");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reducer = (state, action) => {
  if (action instanceof _public.DataView) {
    return {
      status: 'ready',
      dataView: action
    };
  } else if (action instanceof Error) {
    return {
      ...state,
      status: 'error'
    };
  }
  return state;
};
const useCaseEventsDataView = indexPattern => {
  const {
    services
  } = (0, _kibana.useKibana)();
  const toasts = (0, _kibana.useToasts)();
  const [state, dispatch] = (0, _react.useReducer)(reducer, {
    status: 'loading',
    dataView: undefined
  });
  (0, _react.useEffect)(() => {
    const createAdhocDataView = async () => {
      try {
        const adhocDataView = await services.data.dataViews.create({
          title: indexPattern
        });
        dispatch(adhocDataView);
      } catch (error) {
        dispatch(error);
        if (error instanceof Error) {
          if (error.name !== 'AbortError') {
            toasts.addError(error, {
              title: _translations.DATA_VIEW_ERROR
            });
          }
        }
      }
    };
    createAdhocDataView();
  }, [indexPattern, services.data.dataViews, services.fieldFormats, toasts]);
  return state;
};
exports.useCaseEventsDataView = useCaseEventsDataView;