"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentStatusText = exports.RELEASING_LABEL = exports.ISOLATING_LABEL = exports.ISOLATED_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAgentStatusText = hostStatus => {
  return _i18n.i18n.translate('xpack.securitySolution.endpoint.list.hostStatusValue', {
    defaultMessage: '{hostStatus, select, healthy {Healthy} unhealthy {Unhealthy} updating {Updating} offline {Offline} inactive {Inactive} unenrolled {Unenrolled} other {Unhealthy}}',
    values: {
      hostStatus
    }
  });
};
exports.getAgentStatusText = getAgentStatusText;
const ISOLATING_LABEL = exports.ISOLATING_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.agentAndActionsStatus.isIsolating', {
  defaultMessage: 'Isolating'
});
const RELEASING_LABEL = exports.RELEASING_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.agentAndActionsStatus.isUnIsolating', {
  defaultMessage: 'Releasing'
});
const ISOLATED_LABEL = exports.ISOLATED_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.agentAndActionsStatus.isolated', {
  defaultMessage: 'Isolated'
});