"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INVALID_MUSTACHE_TEMPLATE = void 0;
var _i18n = require("@kbn/i18n");
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVALID_MUSTACHE_TEMPLATE = paramKey => _i18n.i18n.translate('xpack.securitySolution.ruleActions.validation.invalidMustacheTemplateErrorMessage', {
  defaultMessage: '{key} is not valid mustache template',
  values: {
    key: (0, _fp.startCase)(paramKey)
  }
});
exports.INVALID_MUSTACHE_TEMPLATE = INVALID_MUSTACHE_TEMPLATE;