"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.appTelemetryEvents = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cellActionClickedEvent = {
  eventType: _types.AppEventTypes.CellActionClicked,
  schema: {
    fieldName: {
      type: 'keyword',
      _meta: {
        description: 'Field Name',
        optional: false
      }
    },
    actionId: {
      type: 'keyword',
      _meta: {
        description: 'Action id',
        optional: false
      }
    },
    displayName: {
      type: 'keyword',
      _meta: {
        description: 'User friendly action name',
        optional: false
      }
    },
    metadata: {
      type: 'pass_through',
      _meta: {
        description: 'Action metadata',
        optional: true
      }
    }
  }
};
const breadCrumbClickedEvent = {
  eventType: _types.AppEventTypes.BreadcrumbClicked,
  schema: {
    title: {
      type: 'keyword',
      _meta: {
        description: 'Breadcrumb title',
        optional: false
      }
    }
  }
};
const appTelemetryEvents = exports.appTelemetryEvents = [cellActionClickedEvent, breadCrumbClickedEvent];