"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewPicker = void 0;
var _public = require("@kbn/unified-search-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public2 = require("@kbn/data-views-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _global_query_string = require("../../../common/utils/global_query_string");
var _use_url_state = require("../../../common/hooks/use_url_state");
var _kibana = require("../../../common/lib/kibana");
var _selectors = require("../../redux/selectors");
var _slices = require("../../redux/slices");
var _use_select_data_view = require("../../hooks/use_select_data_view");
var _constants = require("../../constants");
var _use_saved_data_views = require("../../hooks/use_saved_data_views");
var _translations = require("./translations");
var _constants2 = require("./constants");
var _use_data_view = require("../../hooks/use_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/data_view_manager/components/data_view_picker/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataViewPicker = exports.DataViewPicker = /*#__PURE__*/(0, _react.memo)(({
  scope,
  onClosePopover,
  disabled
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const selectDataView = (0, _use_select_data_view.useSelectDataView)();
  const {
    services: {
      dataViewEditor,
      data,
      dataViewFieldEditor,
      fieldFormats
    }
  } = (0, _kibana.useKibana)();
  const canEditDataView = (0, _react.useMemo)(() => Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView()), [dataViewEditor]);
  const closeFieldEditor = (0, _react.useRef)();
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)(scope);
  const {
    adhocDataViews: adhocDataViewSpecs,
    defaultDataViewId
  } = (0, _reactRedux.useSelector)(_selectors.sharedStateSelector);
  const adhocDataViews = (0, _react.useMemo)(() => {
    return adhocDataViewSpecs.map(spec => new _public2.DataView({
      spec,
      fieldFormats
    }));
  }, [adhocDataViewSpecs, fieldFormats]);
  const savedDataViews = (0, _use_saved_data_views.useSavedDataViews)();
  const isDefaultSourcerer = scope === _constants.DataViewManagerScopeName.default;
  const isExploreSourcerer = scope === _constants.DataViewManagerScopeName.explore;
  const updateUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.sourcerer);
  const dataViewId = dataView === null || dataView === void 0 ? void 0 : dataView.id;

  // NOTE: this function is called in response to user interaction with the picker,
  // hence - it is the only place where we should update the url param for the data view selection.
  const handleChangeDataView = (0, _react.useCallback)((id, indexPattern = '') => {
    selectDataView({
      id,
      scope
    });
    if (isDefaultSourcerer) {
      updateUrlParam({
        [_constants.DataViewManagerScopeName.default]: {
          id,
          // NOTE: Boolean filter for removing empty patterns
          selectedPatterns: indexPattern.split(',').filter(Boolean)
        }
      });
    }
    if (isExploreSourcerer) {
      updateUrlParam({
        [_constants.DataViewManagerScopeName.explore]: {
          id,
          // NOTE: Boolean filter for removing empty patterns
          selectedPatterns: indexPattern.split(',').filter(Boolean)
        }
      });
    }
  }, [isDefaultSourcerer, isExploreSourcerer, scope, selectDataView, updateUrlParam]);
  const handleCreateNewDataView = (0, _react.useCallback)(newDataView => {
    if (!newDataView.id) {
      return;
    }
    dispatch(_slices.sharedDataViewManagerSlice.actions.addDataView(newDataView));
    handleChangeDataView(newDataView.id, newDataView.getIndexPattern());
  }, [dispatch, handleChangeDataView]);
  const editField = (0, _react.useCallback)(async (fieldName, _uiAction = 'edit') => {
    var _dataViewInstance$isP;
    if (!dataViewId) {
      return;
    }
    const dataViewInstance = await data.dataViews.get(dataViewId);
    // Modifications to the fields do not trigger cache invalidation, but should as `fields` will be stale.
    if ((_dataViewInstance$isP = dataViewInstance.isPersisted) !== null && _dataViewInstance$isP !== void 0 && _dataViewInstance$isP.call(dataViewInstance)) {
      data.dataViews.clearInstanceCache(dataViewId);
    }
    closeFieldEditor.current = await dataViewFieldEditor.openEditor({
      ctx: {
        dataView: dataViewInstance
      },
      fieldName,
      onSave: async () => {
        if (!dataViewInstance.id) {
          return;
        }
        handleChangeDataView(dataViewInstance.id, dataViewInstance.getIndexPattern());
      }
    });
  }, [dataViewId, data.dataViews, dataViewFieldEditor, handleChangeDataView]);
  const getDataViewHelpText = (0, _react.useCallback)(dv => dv.id === defaultDataViewId ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.dataViewManager.getDataViewHelpText",
    defaultMessage: "Changes made here won't be saved permanently. To update the default Security indices, edit {code} in Stack Management > Advanced Settings.",
    values: {
      code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 19
        }
      }, 'securitySolution:defaultIndex')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }) : undefined, [defaultDataViewId]);

  /**
   * Selects data view again. After changes are made to the data view, this results in cache invalidation and will force the reload everywhere.
   */
  const handleDataViewModified = (0, _react.useMemo)(() => {
    if (!canEditDataView) {
      return undefined;
    }
    return updatedDataView => {
      if (!updatedDataView.id) {
        return;
      }
      handleChangeDataView(updatedDataView.id, updatedDataView.getIndexPattern());
    };
  }, [canEditDataView, handleChangeDataView]);
  const handleAddField = (0, _react.useMemo)(() => canEditDataView ? () => editField(undefined, 'add') : undefined, [editField, canEditDataView]);
  const triggerConfig = (0, _react.useMemo)(() => {
    if (status === 'loading') {
      return {
        label: _translations.LOADING
      };
    }
    return {
      label: (dataView === null || dataView === void 0 ? void 0 : dataView.name) || (dataView === null || dataView === void 0 ? void 0 : dataView.id) || 'Data view'
    };
  }, [dataView === null || dataView === void 0 ? void 0 : dataView.id, dataView === null || dataView === void 0 ? void 0 : dataView.name, status]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _constants2.DATA_VIEW_PICKER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.DataViewPicker, {
    isDisabled: status !== 'ready' || disabled,
    currentDataViewId: dataViewId || (defaultDataViewId !== null && defaultDataViewId !== void 0 ? defaultDataViewId : undefined),
    trigger: triggerConfig,
    onChangeDataView: handleChangeDataView,
    onEditDataView: handleDataViewModified,
    onAddField: handleAddField,
    onDataViewCreated: handleCreateNewDataView,
    adHocDataViews: adhocDataViews,
    savedDataViews: savedDataViews,
    onClosePopover: onClosePopover,
    getDataViewHelpText: getDataViewHelpText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }));
});
DataViewPicker.displayName = 'DataviewPicker';