"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLACEHOLDER = exports.NEW_TERMS_FIELDS_LABEL = exports.MIN_FIELDS_COUNT_VALIDATION_ERROR = exports.MAX_FIELDS_COUNT_VALIDATION_ERROR = exports.HELP_TEXT = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_TERMS_FIELDS_LABEL = exports.NEW_TERMS_FIELDS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.newTermsFieldsLabel', {
  defaultMessage: 'Fields'
});
const PLACEHOLDER = exports.PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.newTermsField.placeholderText', {
  defaultMessage: 'Select a field'
});
const HELP_TEXT = exports.HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldNewTermsFieldHelpText', {
  defaultMessage: 'Select a field to check for new terms.'
});
const MIN_FIELDS_COUNT_VALIDATION_ERROR = exports.MIN_FIELDS_COUNT_VALIDATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.newTermsField.minFieldsCountError', {
  defaultMessage: 'A minimum of one field is required.'
});
const MAX_FIELDS_COUNT_VALIDATION_ERROR = exports.MAX_FIELDS_COUNT_VALIDATION_ERROR = {
  length: _constants.MAX_NUMBER_OF_NEW_TERMS_FIELDS,
  message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.validations.stepDefineRule.newTermsField.maxFieldsCountError', {
    defaultMessage: 'Number of fields must be 3 or less.'
  })
};