"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobCompatibilityCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _callouts = require("../../../../common/components/callouts");
var _use_installed_security_jobs = require("../../../../common/components/ml/hooks/use_installed_security_jobs");
var _affected_job_ids = require("../../../../../common/machine_learning/affected_job_ids");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/ml_job_compatibility_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mlJobCompatibilityCalloutMessage = {
  type: 'primary',
  id: 'ml-job-compatibility',
  title: i18n.ML_JOB_COMPATIBILITY_CALLOUT_TITLE,
  description: /*#__PURE__*/_react.default.createElement(i18n.MlJobCompatibilityCalloutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 16
    }
  })
};
const MlJobCompatibilityCalloutComponent = () => {
  const {
    loading,
    jobs
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobs)();
  const newJobsInstalled = jobs.some(job => _affected_job_ids.affectedJobIds.includes(job.id));
  return /*#__PURE__*/_react.default.createElement(_callouts.CallOutSwitcher, {
    namespace: "detections",
    condition: !loading && newJobsInstalled,
    message: mlJobCompatibilityCalloutMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  });
};
const MlJobCompatibilityCallout = exports.MlJobCompatibilityCallout = /*#__PURE__*/(0, _react.memo)(MlJobCompatibilityCalloutComponent);