"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../../../../common/constants");
var _types = require("../../../../app/types");
var _links = require("../../../../common/components/links");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _kibana = require("../../../../common/lib/kibana");
var _privileges = require("../../../../common/utils/privileges");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _missing_privileges = require("../../../../common/components/missing_privileges");
var _ml_job_compatibility_callout = require("../../components/ml_job_compatibility_callout");
var _need_admin_for_update_rules_callout = require("../../../rule_management/components/callouts/need_admin_for_update_rules_callout");
var _add_elastic_rules_button = require("../../components/pre_packaged_rules/add_elastic_rules_button");
var _value_lists_management_flyout = require("../../components/value_lists_management_flyout");
var _user_info = require("../../../../detections/components/user_info");
var _use_lists_config = require("../../../../detections/containers/detection_engine/lists/use_lists_config");
var _helpers = require("../../../common/helpers");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _rules_table = require("../../components/rules_table");
var _rules_table_context = require("../../components/rules_table/rules_table/rules_table_context");
var _header_page = require("../../../../common/components/header_page");
var _rule_update_callouts = require("../../components/rule_update_callouts/rule_update_callouts");
var _blog_post_prebuilt_rule_customization_callout = require("../../components/blog_post_prebuilt_rule_customization_callout");
var _rule_import_modal = require("../../components/rule_import_modal/rule_import_modal");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _rules_feature_tour = require("../../components/rules_table/feature_tour/rules_feature_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/pages/rule_management/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesPageComponent = () => {
  const [isImportModalVisible, showImportModal, hideImportModal] = (0, _use_bool_state.useBoolState)();
  const [isValueListFlyoutVisible, showValueListFlyout, hideValueListFlyout] = (0, _use_bool_state.useBoolState)();
  const kibanaServices = (0, _kibana.useKibana)().services;
  const {
    navigateToApp
  } = kibanaServices.application;
  const [{
    loading: userInfoLoading,
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    canWriteIndex: canWriteListsIndex,
    canCreateIndex: canCreateListsIndex,
    needsConfiguration: needsListsConfiguration,
    needsIndex: needsListsIndex
  } = (0, _use_lists_config.useListsConfig)();
  const loading = userInfoLoading || listsConfigLoading;
  const isDoesNotMatchForIndicatorMatchRuleEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('doesNotMatchForIndicatorMatchRuleEnabled');
  if ((0, _helpers.redirectToDetections)(isSignalIndexExists, isAuthenticated, hasEncryptionKey, needsListsConfiguration)) {
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.alerts,
      path: (0, _redirect_to_detection_engine.getDetectionEngineUrl)()
    });
    return null;
  }

  // - if lists data stream does not exist and user doesn't have enough privileges to create it,
  // lists button should be disabled
  // - if data stream exists and user doesn't have enough privileges to create it,
  // user still can import value lists, so button should not be disabled if user has enough other privileges
  const cantCreateNonExistentListIndex = needsListsIndex && !canCreateListsIndex;
  const isImportValueListDisabled = cantCreateNonExistentListIndex || !canWriteListsIndex || !canUserCRUD || loading;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_need_admin_for_update_rules_callout.NeedAdminForUpdateRulesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ml_job_compatibility_callout.MlJobCompatibilityCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_value_lists_management_flyout.ValueListsFlyout, {
    showFlyout: isValueListFlyoutVisible,
    onClose: hideValueListFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_import_modal.RuleImportModal, {
    isImportModalVisible: isImportModalVisible,
    hideImportModal: hideImportModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rules_table_context.RulesTableContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_add_elastic_rules_button.AddElasticRulesButton, {
    isDisabled: !canUserCRUD || loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: cantCreateNonExistentListIndex ? i18n.UPLOAD_VALUE_LISTS_PRIVILEGES_TOOLTIP : i18n.UPLOAD_VALUE_LISTS_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "open-value-lists-modal-button",
    iconType: "importAction",
    isDisabled: isImportValueListDisabled,
    onClick: showValueListFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 19
    }
  }, i18n.IMPORT_VALUE_LISTS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "rules-import-modal-button",
    iconType: "importAction",
    isDisabled: !(0, _privileges.hasUserCRUDPermission)(canUserCRUD) || loading,
    onClick: showImportModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  }, i18n.IMPORT_RULE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    id: _rules_feature_tour.CREATE_NEW_RULE_TOUR_ANCHOR,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    "data-test-subj": "create-new-rule",
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !(0, _privileges.hasUserCRUDPermission)(canUserCRUD) || loading,
    deepLinkId: _types.SecurityPageName.rulesCreate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }, i18n.ADD_NEW_RULE)), isDoesNotMatchForIndicatorMatchRuleEnabled && /*#__PURE__*/_react.default.createElement(_rules_feature_tour.RuleFeatureTour, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 62
    }
  }))), /*#__PURE__*/_react.default.createElement(_rule_update_callouts.RuleUpdateCallouts, {
    shouldShowUpdateRulesCallout: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_alertsUiShared.MaintenanceWindowCallout, {
    kibanaServices: kibanaServices,
    categories: [_coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_blog_post_prebuilt_rule_customization_callout.BlogPostPrebuiltRuleCustomizationCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_rules_table.AllRules, {
    "data-test-subj": "all-rules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.rules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }));
};
const RulesPage = exports.RulesPage = /*#__PURE__*/_react.default.memo(RulesPageComponent);