"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckEndpointPermissions = void 0;
var _constants = require("../../../../common/endpoint/service/response_actions/constants");
var _utils = require("../../../../common/endpoint/service/response_actions/utils");
var _user_privileges = require("../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// returns false if the user does have the required privileges to execute the action, returns true if the user does not have the required privileges
const useCheckEndpointPermissions = action => {
  var _action$params;
  const endpointPrivileges = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  if ((action === null || action === void 0 ? void 0 : action.actionTypeId) === '.endpoint' && action !== null && action !== void 0 && (_action$params = action.params) !== null && _action$params !== void 0 && _action$params.command) {
    return !(0, _utils.getRbacControl)({
      commandName: _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[action.params.command],
      privileges: endpointPrivileges
    });
  }
};
exports.useCheckEndpointPermissions = useCheckEndpointPermissions;