"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSupportedResponseActionTypes = void 0;
var _react = require("react");
var _user_privileges = require("../../common/components/user_privileges");
var _get_supported_response_actions = require("./get_supported_response_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSupportedResponseActionTypes = () => {
  const [supportedResponseActionTypes, setSupportedResponseActionTypes] = (0, _react.useState)();
  const {
    canIsolateHost,
    canKillProcess,
    canSuspendProcess
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const userHasPermissionsToExecute = (0, _react.useMemo)(() => ({
    endpoint: canIsolateHost || canKillProcess || canSuspendProcess
  }), [canIsolateHost, canKillProcess, canSuspendProcess]);
  (0, _react.useEffect)(() => {
    const supportedTypes = (0, _get_supported_response_actions.getSupportedResponseActions)(_get_supported_response_actions.responseActionTypes, userHasPermissionsToExecute);
    setSupportedResponseActionTypes(supportedTypes);
  }, [userHasPermissionsToExecute]);
  return supportedResponseActionTypes;
};
exports.useSupportedResponseActionTypes = useSupportedResponseActionTypes;