"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegendMap = exports.getLegendItemFromRawBucket = exports.getLegendItemFromFlattenedBucket = exports.getFirstGroupLegendItems = void 0;
var _uuid = require("uuid");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _ecs_safety_helpers = require("../../../../../../../../common/endpoint/models/ecs_safety_helpers");
var _chart_palette = require("../chart_palette");
var _helpers = require("../../../../../../../common/components/drag_and_drop/helpers");
var _labels = require("../labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLegendItemFromRawBucket = ({
  bucket,
  colorPalette,
  maxRiskSubAggregations,
  showColor,
  stackByField0
}) => {
  var _maxRiskSubAggregatio, _firstNonNullValue, _ref2, _bucket$key_as_string2;
  return {
    color: showColor ? (0, _chart_palette.getFillColor)({
      riskScore: (_maxRiskSubAggregatio = maxRiskSubAggregations[(_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)(bucket.key)) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '']) !== null && _maxRiskSubAggregatio !== void 0 ? _maxRiskSubAggregatio : 0,
      colorPalette
    }) : undefined,
    count: bucket.doc_count,
    dataProviderId: (0, _helpers.escapeDataProviderId)(`draggable-legend-item-treemap-${stackByField0}-${bucket.key}-${(0, _uuid.v4)()}`),
    render: () => {
      var _ref, _bucket$key_as_string, _bucket$maxRiskSubAgg;
      return (0, _labels.getLabel)({
        baseLabel: (_ref = (_bucket$key_as_string = bucket.key_as_string) !== null && _bucket$key_as_string !== void 0 ? _bucket$key_as_string : (0, _ecs_safety_helpers.firstNonNullValue)(bucket.key)) !== null && _ref !== void 0 ? _ref : '',
        // prefer key_as_string when available, because it contains a formatted date
        riskScore: (_bucket$maxRiskSubAgg = bucket.maxRiskSubAggregation) === null || _bucket$maxRiskSubAgg === void 0 ? void 0 : _bucket$maxRiskSubAgg.value
      });
    },
    field: stackByField0,
    value: (_ref2 = (_bucket$key_as_string2 = bucket.key_as_string) !== null && _bucket$key_as_string2 !== void 0 ? _bucket$key_as_string2 : (0, _ecs_safety_helpers.firstNonNullValue)(bucket.key)) !== null && _ref2 !== void 0 ? _ref2 : 0,
    scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage
  };
};
exports.getLegendItemFromRawBucket = getLegendItemFromRawBucket;
const getLegendItemFromFlattenedBucket = ({
  colorPalette,
  flattenedBucket: {
    key,
    stackByField1Key,
    stackByField1DocCount
  },
  maxRiskSubAggregations,
  stackByField0,
  stackByField1
}) => {
  var _maxRiskSubAggregatio2, _firstNonNullValue2;
  return {
    color: (0, _chart_palette.getFillColor)({
      riskScore: (_maxRiskSubAggregatio2 = maxRiskSubAggregations[(_firstNonNullValue2 = (0, _ecs_safety_helpers.firstNonNullValue)(key)) !== null && _firstNonNullValue2 !== void 0 ? _firstNonNullValue2 : '']) !== null && _maxRiskSubAggregatio2 !== void 0 ? _maxRiskSubAggregatio2 : 0,
      colorPalette
    }),
    count: stackByField1DocCount,
    dataProviderId: (0, _helpers.escapeDataProviderId)(`draggable-legend-item-treemap-${key}-${stackByField1Key}-${(0, _uuid.v4)()}`),
    render: () => `${stackByField1Key}`,
    field: `${stackByField1}`,
    value: `${stackByField1Key}`,
    scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage
  };
};
exports.getLegendItemFromFlattenedBucket = getLegendItemFromFlattenedBucket;
const getFirstGroupLegendItems = ({
  buckets,
  colorPalette,
  maxRiskSubAggregations,
  stackByField0
}) => buckets.map(bucket => getLegendItemFromRawBucket({
  bucket,
  colorPalette,
  maxRiskSubAggregations,
  showColor: true,
  stackByField0
}));
exports.getFirstGroupLegendItems = getFirstGroupLegendItems;
const getLegendMap = ({
  buckets,
  colorPalette,
  maxRiskSubAggregations,
  stackByField0
}) => buckets.reduce((acc, bucket) => {
  var _firstNonNullValue3;
  return {
    ...acc,
    [(_firstNonNullValue3 = (0, _ecs_safety_helpers.firstNonNullValue)(bucket.key)) !== null && _firstNonNullValue3 !== void 0 ? _firstNonNullValue3 : '']: [getLegendItemFromRawBucket({
      bucket,
      colorPalette,
      maxRiskSubAggregations,
      showColor: false,
      // don't show colors for stackByField0
      stackByField0
    })]
  };
}, {});
exports.getLegendMap = getLegendMap;