"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchPrivileges = exports.useFetchDetectionEnginePrivileges = void 0;
var _react = require("react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _api = require("../../containers/detection_engine/alerts/api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchPrivileges = () => (0, _securitysolutionHookUtils.useAsync)((0, _securitysolutionHookUtils.withOptionalSignal)(_api.getUserPrivilege));
exports.useFetchPrivileges = useFetchPrivileges;
const useFetchDetectionEnginePrivileges = (isAppAvailable = true) => {
  const {
    start,
    ...detectionEnginePrivileges
  } = useFetchPrivileges();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(() => {
    const {
      loading,
      result,
      error
    } = detectionEnginePrivileges;
    if (isAppAvailable && !loading && !(result || error)) {
      abortCtrlRef.current.abort();
      abortCtrlRef.current = new AbortController();
      start({
        signal: abortCtrlRef.current.signal
      });
    }
  }, [start, detectionEnginePrivileges, isAppAvailable]);
  (0, _react.useEffect)(() => {
    return () => {
      abortCtrlRef.current.abort();
    };
  }, []);
  (0, _react.useEffect)(() => {
    const error = detectionEnginePrivileges.error;
    if (error != null) {
      addError(error, {
        title: i18n.DETECTION_ENGINE_PRIVILEGES_FETCH_FAILURE
      });
    }
  }, [addError, detectionEnginePrivileges.error]);
  return detectionEnginePrivileges;
};
exports.useFetchDetectionEnginePrivileges = useFetchDetectionEnginePrivileges;