"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PICK_ASSET_CRITICALITY = exports.CRITICALITY_LEVEL_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PICK_ASSET_CRITICALITY = exports.PICK_ASSET_CRITICALITY = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticality.pickerText', {
  defaultMessage: 'Change asset criticality'
});
const CRITICALITY_LEVEL_TITLE = exports.CRITICALITY_LEVEL_TITLE = {
  unassigned: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticality.levelTitle.unassigned', {
    defaultMessage: 'Unassigned'
  }),
  medium_impact: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticality.levelTitle.mediumImpact', {
    defaultMessage: 'Medium Impact'
  }),
  low_impact: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticality.levelTitle.lowImpact', {
    defaultMessage: 'Low Impact'
  }),
  high_impact: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticality.levelTitle.highImpact', {
    defaultMessage: 'High Impact'
  }),
  extreme_impact: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.assetCriticality.levelTitle.extremeImpact', {
    defaultMessage: 'Extreme Impact'
  })
};