"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrivilegedAccessDetectionRoutes = void 0;
var _react = require("react");
var _constants = require("../../../../../../common/entity_analytics/constants");
var _kibana = require("../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRIVILEGED_ACCESS_DETECTION_INDEX_PATTERN = 'logs-*,ml_okta_multiple_user_sessions_pad.all,ml_windows_privilege_type_pad.all';
const usePrivilegedAccessDetectionRoutes = () => {
  const http = (0, _kibana.useKibana)().services.http;
  return (0, _react.useMemo)(() => {
    const getPrivilegedAccessDetectionStatus = async () => {
      return http.fetch('/api/entity_analytics/privileged_user_monitoring/pad/status', {
        method: 'GET',
        version: _constants.API_VERSIONS.public.v1
      });
    };
    const installPrivilegedAccessDetectionPackage = async () => {
      return http.fetch('/api/entity_analytics/privileged_user_monitoring/pad/install', {
        method: 'POST',
        version: _constants.API_VERSIONS.public.v1
      });
    };
    const setupPrivilegedAccessDetectionMlModule = async () => {
      return http.fetch('/internal/ml/modules/setup/pad-ml', {
        version: '1',
        method: 'POST',
        body: JSON.stringify({
          indexPatternName: PRIVILEGED_ACCESS_DETECTION_INDEX_PATTERN,
          useDedicatedIndex: false,
          startDatafeed: false
        })
      });
    };
    return {
      getPrivilegedAccessDetectionStatus,
      installPrivilegedAccessDetectionPackage,
      setupPrivilegedAccessDetectionMlModule
    };
  }, [http]);
};
exports.usePrivilegedAccessDetectionRoutes = usePrivilegedAccessDetectionRoutes;