"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_NAME = exports.USER_ID = exports.USERS = exports.UNIT = exports.ROWS_5 = exports.ROWS_10 = exports.GROUP_NAME = exports.GROUP_ID = exports.DOCUMENT_COUNT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USERS = exports.USERS = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.usersTitle', {
  defaultMessage: 'Users'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {user} other {users}}`
});

// Columns
exports.UNIT = UNIT;
const USER_NAME = exports.USER_NAME = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.columns.userNameTitle', {
  defaultMessage: 'User'
});
const USER_ID = exports.USER_ID = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.columns.userIdTitle', {
  defaultMessage: 'ID'
});
const GROUP_NAME = exports.GROUP_NAME = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.columns.groupNameTitle', {
  defaultMessage: 'Group name'
});
const GROUP_ID = exports.GROUP_ID = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.columns.groupIdTitle', {
  defaultMessage: 'Group ID'
});
const DOCUMENT_COUNT = exports.DOCUMENT_COUNT = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.columns.documentCountTitle', {
  defaultMessage: 'Document count'
});

// Row Select
const ROWS_5 = exports.ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
const ROWS_10 = exports.ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.network.ipDetails.usersTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});