"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersDetailsTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _risk_details_tab_body = require("../../../../entity_analytics/components/risk_details_tab_body");
var _types = require("../../../../../common/entity_analytics/types");
var _model = require("../../store/model");
var _anomalies_user_table = require("../../../../common/components/ml/tables/anomalies_user_table");
var _anomalies_query_tab_body = require("../../../../common/containers/anomalies/anomalies_query_tab_body");
var _constants = require("../constants");
var _events_tab = require("../../../../common/components/events_tab");
var _navigation = require("../navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/users/pages/details/details_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UsersDetailsTabs = exports.UsersDetailsTabs = /*#__PURE__*/_react.default.memo(({
  deleteQuery,
  filterQuery,
  from,
  indexNames,
  isInitializing,
  setQuery,
  to,
  type,
  detailName,
  userDetailFilter
}) => {
  const tabProps = {
    deleteQuery,
    endDate: to,
    filterQuery,
    indexNames,
    skip: isInitializing || filterQuery === undefined,
    setQuery,
    startDate: from,
    type,
    userName: detailName
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.usersDetailsPagePath}/:tabName(${_model.UsersTableType.authentications})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.AuthenticationsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.usersDetailsPagePath}/:tabName(${_model.UsersTableType.anomalies})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    AnomaliesTableComponent: _anomalies_user_table.AnomaliesUserTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.usersDetailsPagePath}/:tabName(${_model.UsersTableType.events})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_events_tab.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: userDetailFilter,
    tableId: _securitysolutionDataTable.TableId.usersPageEvents
  }, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.usersDetailsPagePath}/:tabName(${_model.UsersTableType.risk})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_details_tab_body.RiskDetailsTabBody, (0, _extends2.default)({}, tabProps, {
    riskEntity: _types.EntityType.user,
    entityName: tabProps.userName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }))));
});
UsersDetailsTabs.displayName = 'UsersDetailsTabs';