"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeActionButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _use_basic_data_from_details_data = require("../hooks/use_basic_data_from_details_data");
var _get_event_details_field_values = require("../../../../common/lib/endpoint/utils/get_event_details_field_values");
var _take_action_dropdown = require("./take_action_dropdown");
var _alert_context_menu = require("../../../../detections/components/alerts_table/timeline_actions/alert_context_menu");
var _event_filters_flyout = require("../../../../management/pages/event_filters/view/components/event_filters_flyout");
var _osquery_flyout = require("../../../../detections/components/osquery/osquery_flyout");
var _context = require("../context");
var _use_host_isolation = require("../hooks/use_host_isolation");
var _use_refetch_by_scope = require("../../right/hooks/use_refetch_by_scope");
var _use_add_exception_flyout = require("../../../../detections/components/alerts_table/timeline_actions/use_add_exception_flyout");
var _helpers = require("../../../../helpers");
var _use_event_filter_modal = require("../../../../detections/components/alerts_table/timeline_actions/use_event_filter_modal");
var _header = require("../../isolate_host/header");
var _content = require("../../isolate_host/content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/shared/components/take_action_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Take action button in the panel footer
 */
const TakeActionButton = () => {
  var _dataAsNestedObject$k2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const maskProps = (0, _react.useMemo)(() => ({
    style: `z-index: ${euiTheme.levels.flyout + 4}`
  }),
  // we need this flyout to be above the timeline flyout (which has a z-index of 1003)
  [euiTheme]);
  const {
    closeFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    dataFormattedForFieldBrowser,
    dataAsNestedObject,
    refetchFlyoutData,
    scopeId
  } = (0, _context.useDocumentDetailsContext)();

  // host isolation interaction
  const {
    isolateAction,
    isHostIsolationPanelOpen,
    showHostIsolationPanel,
    isIsolateActionSuccessBannerVisible,
    handleIsolationActionSuccess,
    showAlertDetails
  } = (0, _use_host_isolation.useHostIsolation)();
  const {
    hostName
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    refetch: refetchAll
  } = (0, _use_refetch_by_scope.useRefetchByScope)({
    scopeId
  });

  // exception interaction
  const ruleIndexRaw = (0, _react.useMemo)(() => {
    var _find$values, _find, _find2;
    return (_find$values = (_find = (0, _fp.find)({
      category: 'signal',
      field: 'signal.rule.index'
    }, dataFormattedForFieldBrowser)) === null || _find === void 0 ? void 0 : _find.values) !== null && _find$values !== void 0 ? _find$values : (_find2 = (0, _fp.find)({
      category: 'kibana',
      field: 'kibana.alert.rule.parameters.index'
    }, dataFormattedForFieldBrowser)) === null || _find2 === void 0 ? void 0 : _find2.values;
  }, [dataFormattedForFieldBrowser]);
  const ruleIndex = (0, _react.useMemo)(() => Array.isArray(ruleIndexRaw) ? ruleIndexRaw : undefined, [ruleIndexRaw]);
  const ruleDataViewIdRaw = (0, _react.useMemo)(() => {
    var _find$values2, _find3, _find4;
    return (_find$values2 = (_find3 = (0, _fp.find)({
      category: 'signal',
      field: 'signal.rule.data_view_id'
    }, dataFormattedForFieldBrowser)) === null || _find3 === void 0 ? void 0 : _find3.values) !== null && _find$values2 !== void 0 ? _find$values2 : (_find4 = (0, _fp.find)({
      category: 'kibana',
      field: 'kibana.alert.rule.parameters.data_view_id'
    }, dataFormattedForFieldBrowser)) === null || _find4 === void 0 ? void 0 : _find4.values;
  }, [dataFormattedForFieldBrowser]);
  const ruleDataViewId = (0, _react.useMemo)(() => Array.isArray(ruleDataViewIdRaw) ? ruleDataViewIdRaw[0] : undefined, [ruleDataViewIdRaw]);
  const alertSummaryData = (0, _react.useMemo)(() => [{
    category: 'signal',
    field: 'signal.rule.id',
    name: 'ruleId'
  }, {
    category: 'signal',
    field: 'signal.rule.rule_id',
    name: 'ruleRuleId'
  }, {
    category: 'signal',
    field: 'signal.rule.name',
    name: 'ruleName'
  }, {
    category: 'signal',
    field: 'kibana.alert.workflow_status',
    name: 'alertStatus'
  }, {
    category: '_id',
    field: '_id',
    name: 'eventId'
  }].reduce((acc, curr) => ({
    ...acc,
    [curr.name]: (0, _get_event_details_field_values.getAlertDetailsFieldValue)({
      category: curr.category,
      field: curr.field
    }, dataFormattedForFieldBrowser)
  }), {}), [dataFormattedForFieldBrowser]);
  const {
    exceptionFlyoutType,
    openAddExceptionFlyout,
    onAddExceptionTypeClick,
    onAddExceptionCancel,
    onAddExceptionConfirm
  } = (0, _use_add_exception_flyout.useExceptionFlyout)({
    refetch: refetchAll,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId)
  });

  // event filter interaction
  const {
    closeAddEventFilterModal,
    isAddEventFilterModalOpen,
    onAddEventFilterClick
  } = (0, _use_event_filter_modal.useEventFilterModal)();

  // osquery interaction
  const [isOsqueryFlyoutOpenWithAgentId, setOsqueryFlyoutOpenWithAgentId] = (0, _react.useState)(null);
  const closeOsqueryFlyout = (0, _react.useCallback)(() => {
    setOsqueryFlyoutOpenWithAgentId(null);
  }, [setOsqueryFlyoutOpenWithAgentId]);
  const alertId = (0, _react.useMemo)(() => {
    var _dataAsNestedObject$k;
    return dataAsNestedObject !== null && dataAsNestedObject !== void 0 && (_dataAsNestedObject$k = dataAsNestedObject.kibana) !== null && _dataAsNestedObject$k !== void 0 && _dataAsNestedObject$k.alert ? dataAsNestedObject === null || dataAsNestedObject === void 0 ? void 0 : dataAsNestedObject._id : null;
  }, [dataAsNestedObject === null || dataAsNestedObject === void 0 ? void 0 : dataAsNestedObject._id, dataAsNestedObject === null || dataAsNestedObject === void 0 ? void 0 : (_dataAsNestedObject$k2 = dataAsNestedObject.kibana) === null || _dataAsNestedObject$k2 === void 0 ? void 0 : _dataAsNestedObject$k2.alert]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dataAsNestedObject && /*#__PURE__*/_react.default.createElement(_take_action_dropdown.TakeActionDropdown, {
    dataFormattedForFieldBrowser: dataFormattedForFieldBrowser,
    dataAsNestedObject: dataAsNestedObject,
    handleOnEventClosed: closeFlyout,
    isHostIsolationPanelOpen: isHostIsolationPanelOpen,
    onAddEventFilterClick: onAddEventFilterClick,
    onAddExceptionTypeClick: onAddExceptionTypeClick,
    onAddIsolationStatusClick: showHostIsolationPanel,
    refetchFlyoutData: refetchFlyoutData,
    refetch: refetchAll,
    scopeId: scopeId,
    onOsqueryClick: setOsqueryFlyoutOpenWithAgentId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }), openAddExceptionFlyout && alertSummaryData.ruleId != null && alertSummaryData.ruleRuleId != null && alertSummaryData.eventId != null && /*#__PURE__*/_react.default.createElement(_alert_context_menu.AddExceptionFlyoutWrapper, (0, _extends2.default)({}, alertSummaryData, {
    ruleIndices: ruleIndex,
    ruleDataViewId: ruleDataViewId,
    exceptionListType: exceptionFlyoutType,
    onCancel: onAddExceptionCancel,
    onConfirm: onAddExceptionConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  })), isAddEventFilterModalOpen && dataAsNestedObject != null && /*#__PURE__*/_react.default.createElement(_event_filters_flyout.EventFiltersFlyout, {
    data: dataAsNestedObject,
    onCancel: closeAddEventFilterModal
    // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
    ,
    maskProps: maskProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }), isOsqueryFlyoutOpenWithAgentId && dataAsNestedObject != null && /*#__PURE__*/_react.default.createElement(_osquery_flyout.OsqueryFlyout, {
    agentId: isOsqueryFlyoutOpenWithAgentId,
    defaultValues: alertId ? {
      alertIds: [alertId]
    } : undefined,
    onClose: closeOsqueryFlyout,
    ecsData: dataAsNestedObject,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }), isHostIsolationPanelOpen &&
  /*#__PURE__*/
  // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
  _react.default.createElement(_eui.EuiFlyout, {
    onClose: showAlertDetails,
    size: "m",
    maskProps: maskProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header.IsolateHostPanelHeader, {
    isolateAction: isolateAction,
    data: dataFormattedForFieldBrowser,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_content.IsolateHostPanelContent, {
    isIsolateActionSuccessBannerVisible: isIsolateActionSuccessBannerVisible,
    hostName: hostName,
    alertId: alertId !== null && alertId !== void 0 ? alertId : undefined,
    isolateAction: isolateAction,
    dataFormattedForFieldBrowser: dataFormattedForFieldBrowser,
    showAlertDetails: showAlertDetails,
    handleIsolationActionSuccess: handleIsolationActionSuccess,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  })));
};
exports.TakeActionButton = TakeActionButton;
TakeActionButton.displayName = 'TakeActionButton';