"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGenericEntityCriticality = void 0;
var _reactQuery = require("@kbn/react-query");
var _api = require("../../../../entity_analytics/api/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_KEY = 'generic-entity-asset-criticality';
const useGenericEntityCriticality = ({
  idField,
  idValue,
  enabled
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    fetchAssetCriticality,
    createAssetCriticality,
    deleteAssetCriticality
  } = (0, _api.useEntityAnalyticsRoutes)();
  const genericEntityAssetCriticalityQueryKey = [QUERY_KEY, idField, idValue];
  const getAssetCriticality = (0, _reactQuery.useQuery)({
    queryKey: genericEntityAssetCriticalityQueryKey,
    queryFn: () => fetchAssetCriticality({
      idField,
      idValue
    }),
    retry: false,
    retryOnMount: false,
    enabled
  });
  const assignAssetCriticality = (0, _reactQuery.useMutation)({
    mutationFn: params => {
      if (params.criticalityLevel === 'unassigned') {
        return deleteAssetCriticality({
          idField: params.idField,
          idValue: params.idValue,
          refresh: 'wait_for'
        });
      }
      return createAssetCriticality({
        idField: params.idField,
        idValue: params.idValue,
        criticalityLevel: params.criticalityLevel,
        refresh: 'wait_for'
      });
    },
    onMutate: async params => {
      await queryClient.cancelQueries(genericEntityAssetCriticalityQueryKey);
      const previousData = queryClient.getQueryData(genericEntityAssetCriticalityQueryKey);
      queryClient.setQueryData(genericEntityAssetCriticalityQueryKey, {
        criticality_level: (params === null || params === void 0 ? void 0 : params.criticalityLevel) || 'unassigned'
      });
      return {
        previousData
      };
    },
    onError: (_error, _params, context) => {
      if ((context === null || context === void 0 ? void 0 : context.previousData) === undefined) {
        queryClient.setQueryData(genericEntityAssetCriticalityQueryKey, {
          criticality_level: 'unassigned'
        });
      } else queryClient.setQueryData(genericEntityAssetCriticalityQueryKey, context === null || context === void 0 ? void 0 : context.previousData);
    },
    onSuccess: () => {
      queryClient.invalidateQueries(genericEntityAssetCriticalityQueryKey);
    }
  });
  return {
    getAssetCriticality,
    assignAssetCriticality
  };
};
exports.useGenericEntityCriticality = useGenericEntityCriticality;