"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToHostDetails = void 0;
var _react = require("react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _search_strategy = require("../../../../../common/search_strategy");
var _kibana = require("../../../../common/lib/kibana");
var _host_details_left = require("../../host_details_left");
var _telemetry = require("../../../../common/lib/telemetry");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _constants = require("../../shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToHostDetails = ({
  hostName,
  scopeId,
  isRiskScoreExist,
  hasMisconfigurationFindings,
  hasVulnerabilitiesFindings,
  hasNonClosedAlerts,
  isPreviewMode,
  contextID
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  telemetry.reportEvent(_telemetry.EntityEventTypes.RiskInputsExpandedFlyoutOpened, {
    entity: _search_strategy.EntityType.host
  });
  const isLinkEnabled = (0, _react.useMemo)(() => {
    return !isPreviewMode || isNewNavigationEnabled && isPreviewMode;
  }, [isNewNavigationEnabled, isPreviewMode]);
  const openDetailsPanel = (0, _react.useCallback)(path => {
    const left = {
      id: _host_details_left.HostDetailsPanelKey,
      params: {
        name: hostName,
        scopeId,
        isRiskScoreExist,
        path,
        hasMisconfigurationFindings,
        hasVulnerabilitiesFindings,
        hasNonClosedAlerts
      }
    };
    const right = {
      id: _constants.HostPanelKey,
      params: {
        contextID,
        scopeId,
        hostName
      }
    };

    // When new navigation is enabled, nevigation in preview is enabled and open a new flyout
    if (isNewNavigationEnabled && isPreviewMode) {
      openFlyout({
        right,
        left
      });
    }
    // When not in preview mode, open left panel as usual
    else if (!isPreviewMode) {
      openLeftPanel(left);
    }
  }, [isNewNavigationEnabled, isPreviewMode, openFlyout, openLeftPanel, hostName, scopeId, isRiskScoreExist, hasMisconfigurationFindings, hasVulnerabilitiesFindings, hasNonClosedAlerts, contextID]);
  return {
    openDetailsPanel,
    isLinkEnabled
  };
};
exports.useNavigateToHostDetails = useNavigateToHostDetails;