"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedHostFields = void 0;
var _react = require("react");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _common = require("../../shared/common");
var _endpoint_policy_fields = require("../fields/endpoint_policy_fields");
var _basic_host_fields = require("../fields/basic_host_fields");
var _cloud_fields = require("../fields/cloud_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useObservedHostFields = hostData => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  return (0, _react.useMemo)(() => {
    if (hostData == null) {
      return [];
    }
    return [..._basic_host_fields.basicHostFields, ...(0, _common.getAnomaliesFields)(mlCapabilities), ..._cloud_fields.cloudFields, ..._endpoint_policy_fields.policyFields];
  }, [hostData, mlCapabilities]);
};
exports.useObservedHostFields = useObservedHostFields;