"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToServiceDetails = void 0;
var _expandableFlyout = require("@kbn/expandable-flyout");
var _react = require("react");
var _search_strategy = require("../../../../../common/search_strategy");
var _kibana = require("../../../../common/lib/kibana");
var _telemetry = require("../../../../common/lib/telemetry");
var _service_details_left = require("../../service_details_left");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _constants = require("../../shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToServiceDetails = ({
  serviceName,
  scopeId,
  contextID,
  isRiskScoreExist,
  isPreviewMode
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  const isLinkEnabled = !isPreviewMode || isNewNavigationEnabled && isPreviewMode;
  const openDetailsPanel = (0, _react.useCallback)(path => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.RiskInputsExpandedFlyoutOpened, {
      entity: _search_strategy.EntityType.service
    });
    const left = {
      id: _service_details_left.ServiceDetailsPanelKey,
      params: {
        isRiskScoreExist,
        scopeId,
        service: {
          name: serviceName
        },
        path
      }
    };
    const right = {
      id: _constants.ServicePanelKey,
      params: {
        contextID,
        serviceName,
        scopeId
      }
    };

    // When new navigation is enabled, navigation in preview is enabled and open a new flyout
    if (isNewNavigationEnabled && isPreviewMode) {
      openFlyout({
        right,
        left
      });
    } else if (!isPreviewMode) {
      // When not in preview mode, open left panel as usual
      openLeftPanel(left);
    }
  }, [contextID, isNewNavigationEnabled, isPreviewMode, isRiskScoreExist, openFlyout, openLeftPanel, scopeId, serviceName, telemetry]);
  return {
    openDetailsPanel,
    isLinkEnabled
  };
};
exports.useNavigateToServiceDetails = useNavigateToServiceDetails;