"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClearCommand = void 0;
var _react = require("react");
var _use_console_state_dispatch = require("../../hooks/state_selectors/use_console_state_dispatch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClearCommand = exports.ClearCommand = /*#__PURE__*/(0, _react.memo)(({
  status,
  setStatus
}) => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  (0, _react.useEffect)(() => {
    if (status === 'pending') {
      dispatch({
        type: 'clear'
      });
    }
    setStatus('success');
  }, [status, setStatus, dispatch]);
  return null;
});
ClearCommand.displayName = 'ClearCommand';